/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.cmp.services.payment.salary;

import java.io.UnsupportedEncodingException;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gxnx.cmp.services.utils.Packer;
import kd.ebg.aqap.banks.gxnx.dc.utils.GzipUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QuerySalaryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QuerySalaryPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        String packQuerySalary = Packer.packQuerySalary(bankPayRequest);
        return "CBE011|#" + packQuerySalary;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo info;
        String bankDetailSeqId;
        String[] result;
        int i;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        int index = rspStr.indexOf("#");
        String body = rspStr.substring(index + 1);
        body = Packer.decodeResponse(body);
        Element root = JDomUtils.string2Root((String)body, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String successFileName = JDomUtils.getChildText((Element)opResult, (String)"successFileName");
        String failFileName = JDomUtils.getChildText((Element)opResult, (String)"failFileName");
        byte[] ret2 = GzipUtil.ungzipAndEncoder((String)successFileName);
        String successContent = "";
        try {
            if (ret2 != null) {
                successContent = new String(ret2, RequestContextUtils.getCharset());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] ret3 = GzipUtil.ungzipAndEncoder((String)failFileName);
        String failContent = "";
        try {
            if (ret3 != null) {
                failContent = new String(ret3, RequestContextUtils.getCharset());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty((String)successContent)) {
            String[] content = successContent.split("\\n");
            for (i = 1; i < content.length; ++i) {
                result = content[i].split(",", -1);
                bankDetailSeqId = result[0];
                info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)bankDetailSeqId);
                if (info == null) {
                    this.logger.info("\u627e\u4e0d\u5230\u660e\u7ec6\u53f7\uff1a" + bankDetailSeqId);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QuerySalaryPayImpl_2", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QuerySalaryPayImpl_2", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotEmpty((String)failContent)) {
            String[] fail = failContent.split("\\n");
            for (i = 1; i < fail.length; ++i) {
                result = fail[i].split(",", -1);
                bankDetailSeqId = result[0];
                info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)bankDetailSeqId);
                if (info == null) {
                    this.logger.info("\u627e\u4e0d\u5230\u660e\u7ec6\u53f7\uff1a" + bankDetailSeqId);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QuerySalaryPayImpl_3", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QuerySalaryPayImpl_3", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]));
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE011";
    }

    public String getBizDesc() {
        return null;
    }
}

