/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.cmp.services.payment.sub;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gxnx.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.gxnx.cmp.services.payment.sub.QueryPayImpl;
import kd.ebg.aqap.banks.gxnx.cmp.services.utils.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        String pay = Packer.packSubAcntPay(bankPayRequest);
        return "CBE013|#" + pay;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        int index = rspStr.indexOf("#");
        String body = rspStr.substring(index + 1);
        body = Packer.decodeResponse(body);
        Element root = JDomUtils.string2Root((String)body, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String errorCode = JDomUtils.getChildText((Element)opResult, (String)"errorCode");
        String errorMessage = JDomUtils.getChildText((Element)opResult, (String)"errorMessage");
        if ("000000".equalsIgnoreCase(errorCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_2", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), (String)errorCode, (String)errorMessage);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_3", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), (String)errorCode, (String)errorMessage);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE013";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u96c6\u56e2\u5bf9\u5916\u4ed8\u6b3e", (String)"PayImpl_6", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return BankBusinessConfig.isSubAcnt(paymentInfo.getAccNo());
    }
}

