/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.curandfixed.query;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.curandfixed.utils.PriCafUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CQRA15Impl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA15", curAndFixedInfo.getDetailSeqId());
        Element acc = JDomUtils.addChild((Element)root, (String)"ACC");
        JDomUtils.addChild((Element)acc, (String)"AccType", (String)"9");
        JDomUtils.addChild((Element)acc, (String)"AccSts", (String)"0");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(curAndFixedInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)curAndFixedInfo.getCurrency());
        Element Corp = JDomUtils.addChild((Element)root, (String)"Corp");
        if ("CNY".equalsIgnoreCase(CurrencyUtils.convert2Iso((String)curAndFixedInfo.getCurrency()))) {
            JDomUtils.addChild((Element)Corp, (String)"CshDraFlag", (String)"0");
        } else {
            JDomUtils.addChild((Element)Corp, (String)"CshDraFlag", (String)"1");
        }
        Element Channel = JDomUtils.addChild((Element)root, (String)"Channel");
        JDomUtils.addChild((Element)Channel, (String)"AssFlag", (String)"0");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = ABC_DC_Parser.parseString2Root(s);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$s", (String)"CQRA15Impl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element cmp = root.getChild("Cmp");
        String batchFileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        Element cme = root.getChild("Cme");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        String FieldNum = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        int recordNum = Integer.parseInt(recordNumStr);
        int fieldNum = Integer.parseInt(FieldNum);
        if (StringUtils.isEmpty((String)batchFileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u519c\u884cCQRA15\u67e5\u8be2\u5931\u8d25\u8fd4\u56de\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a", (String)"CQRA15Impl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        if (recordNum != 0) {
            String[] splits = ResponseFileUtils.getDetailRspRecords(batchFileName, "");
            int index = PriCafUtil.indexOf(splits, fieldNum, 2, curAndFixedInfo.getReqNbrWithoutTag());
            if (index == -1) {
                ebBankCurAndFixedResponse.setDetails(cafInfos);
                return ebBankCurAndFixedResponse;
            }
            String rate = splits[index];
            String openDate = splits[index + 9];
            String endDate = splits[index + 10];
            curAndFixedInfo.setOpenDate(openDate);
            curAndFixedInfo.setEndDate(endDate);
        } else {
            CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6587\u4ef6\u7f3a\u5931\u8be5\u7b14\u7406\u8d22\u7684\u4fe1\u606f\u3002", (String)"", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

