/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.BCConvert;
import kd.ebg.aqap.banks.abc.dc.service.acctype.AccTypeEnum;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.DetailFieldUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailFieldConf;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public boolean match(BankDetailRequest request) {
        return "CQRA10".equalsIgnoreCase(BankBusinessConfig.getDetailChoose());
    }

    public String pack(BankDetailRequest request) {
        return this.packDetail(request);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List<DetailInfo> detailInfos = TodayDetailImpl.parseDetail(request.getAcnt().getAccNo(), responseStr);
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CQRA10";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    private String packDetail(BankDetailRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        LocalDate startDate = rqst.getStartDate();
        LocalDate endDate = rqst.getEndDate();
        Element root = ABC_DC_Packer.createABCRoot4New(BankBusinessConfig.getDetailChoose(), Sequence.genSequence());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)corp, (String)"EndDate", (String)endDate.format(DateTimeFormatter.BASIC_ISO_DATE));
        Element channel = JDomUtils.addChild((Element)root, (String)"Channel");
        JDomUtils.addChild((Element)channel, (String)"LastJrnNo", (String)"");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        String accTypeName = AccTypeEnum.getAccNoType(acnt.getAccNo());
        if (StringUtils.isNotEmpty((String)accTypeName)) {
            JDomUtils.addChild((Element)cmp, (String)"DbAccType", (String)accTypeName);
            JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo().substring(accTypeName.length())));
        } else {
            JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        }
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)rqst.getBankCurrency());
        JDomUtils.addChild((Element)cmp, (String)"StartTime", (String)"");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    private static List<DetailInfo> parseDetail(String reqAccNo, String rspStr) {
        String[] splits;
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (PropertiesConstants.getValue((String)"NOT_RECORD").equalsIgnoreCase(RespInfo)) {
            return detailList;
        }
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$s", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return detailList;
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        Element cmp = root.getChild("Cmp");
        if ("1".equalsIgnoreCase(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getDetailRspRecords(fileName, "");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|");
        }
        int fieldNum = Integer.parseInt(fieldNumStr);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        JSONObject receiptJson = new JSONObject();
        DetailFieldConf detailField = DetailFieldUtil.getInstance().getDetailField(EBContext.getContext().getBankVersionID(), "CQRA10");
        for (int i = 0; i < recordNum; ++i) {
            BigDecimal orgAmt;
            receiptJson.clear();
            String accNo = splits[fieldNum * i + 1];
            String currency = splits[fieldNum * i + 2];
            String dateStr = splits[fieldNum * i + 3];
            String timeStr = splits[fieldNum * i + 4];
            String detailNo = splits[fieldNum * i + 5];
            String TrType = splits[fieldNum * i + 6];
            String flag = splits[fieldNum * i + 9];
            String oppDbProv = splits[fieldNum * i + 10];
            String oppAccNo = splits[fieldNum * i + 11];
            String oppAccName = splits[fieldNum * i + 13];
            String oppAccBank = splits[fieldNum * i + 14];
            if (ABC_DC_Parser.is17Lehgth()) {
                oppAccNo = (oppDbProv + oppAccNo).trim();
            }
            String amountStr = splits[fieldNum * i + 18];
            String balanceStr = splits[fieldNum * i + 19];
            String voucherNo = splits[fieldNum * i + 25];
            String CustRef = splits[fieldNum * i + 26];
            String vchno = splits[fieldNum * i + 29];
            String Abs = splits[fieldNum * i + 30];
            String PostScript = splits[fieldNum * i + 31];
            String trFrom = splits[fieldNum * i + 32];
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(currency);
            BigDecimal amout = null;
            if (StrUtil.isEmpty((String)amountStr)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u519c\u884c\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"TodayDetailImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            }
            amout = new BigDecimal(amountStr.trim());
            BigDecimal targetAmt = orgAmt = amout;
            if ("1".equalsIgnoreCase(flag) || "4".equalsIgnoreCase(flag)) {
                targetAmt = targetAmt.abs();
                targetAmt = targetAmt.multiply(new BigDecimal("-1"));
            } else {
                targetAmt = targetAmt.abs();
            }
            if (orgAmt.signum() < 0) {
                detail.setDebitAmount(targetAmt);
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else {
                detail.setCreditAmount(targetAmt);
                detail.setDebitAmount(new BigDecimal("0.00"));
            }
            detail.setOppAccNo(oppAccNo);
            detail.setOppAccName(oppAccName);
            detail.setOppBankName(oppAccBank);
            boolean isEBGSubmit = false;
            String PostScriptHalf = BCConvert.qj2bj(PostScript);
            if (CustRef.indexOf("KD_") != -1) {
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)CustRef);
                detail.setPayBankDetailSeqID(CustRef);
                isEBGSubmit = true;
            } else if (PostScriptHalf.indexOf("_KD_") != -1) {
                String batchNO = PostScriptHalf.substring(0, PostScriptHalf.indexOf("_KD_"));
                PostScriptHalf = PostScriptHalf.substring(batchNO.length() + "_KD_".length());
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)batchNO);
                detail.setPayBankDetailSeqID(batchNO);
                isEBGSubmit = true;
            }
            Map<String, String> bankChargeConfig = BankBusinessConfig.getBankChargeConfig();
            String trFromCn = bankChargeConfig.get(trFrom);
            boolean bankChargeFlag = false;
            if (trFromCn != null) {
                bankChargeFlag = true;
                PostScriptHalf = StrUtil.join((String)";", (String)PostScriptHalf, (String)trFromCn);
            }
            detail.setExplanation(PostScriptHalf);
            detail.setUseCN(TrType);
            if (!isEBGSubmit && TodayDetailImpl.isTransUp(Abs)) {
                detail.setTransType("autotransup");
            } else if (!isEBGSubmit && TodayDetailImpl.isTransDown(Abs)) {
                detail.setTransType("autotransdown");
            } else if (bankChargeFlag) {
                detail.setTransType("bankcharge");
            }
            try {
                LocalDateTime transTime = LocalDateTime.parse(timeStr.substring(0, 14), DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detail.setTransTime(transTime);
                LocalDate transDate = LocalDate.parse(dateStr, DateTimeFormatter.BASIC_ISO_DATE);
                detail.setTransDate(transDate);
            }
            catch (DateTimeParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u4ea4\u6613\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38\u3002", (String)"TodayDetailImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
            }
            if (!StrUtil.isEmpty((String)balanceStr)) {
                detail.setBalance(new BigDecimal(balanceStr.trim()));
            }
            String fixedAccNo = AcntNumberHelper.fixAccNoTo15Or19(accNo);
            String fixedDateStr = timeStr.substring(0, 8);
            StringBuilder sBuffer = new StringBuilder();
            String json = null;
            if (detailField != null) {
                StringBuilder sb = new StringBuilder();
                for (int j = fieldNum * i; j < fieldNum * i + fieldNum; ++j) {
                    sb.append(splits[j]).append(detailField.getSplit());
                }
                json = MatchRule.getInstance().getDetailJsonWithNonStructuredData(detailField.getDetailFields(), sb.toString(), detailField.getSplit());
            }
            if (StringUtils.isNotEmpty(json)) {
                receiptJson = JSON.parseObject(json);
            }
            receiptJson.put("accNo", (Object)fixedAccNo);
            receiptJson.put("transDate", (Object)fixedDateStr);
            receiptJson.put("serialNo", (Object)detailNo);
            receiptJson.put("CustRef", (Object)CustRef);
            receiptJson.put("TimeStab", (Object)timeStr);
            receiptJson.put("TrJrn", (Object)detailNo);
            if (BankBusinessConfig.isPushedFromMaster()) {
                if (StrUtil.isEmpty((String)oppAccNo)) {
                    oppAccNo = "0";
                    receiptJson.put("oppAccNo", (Object)"e");
                } else {
                    oppAccNo = AcntNumberHelper.fixAccNoTo15Or19(oppAccNo);
                    receiptJson.put("oppAccNo", (Object)oppAccNo);
                }
                receiptJson.put("Amount", (Object)targetAmt);
                sBuffer.append(fixedAccNo).append('-').append(fixedDateStr).append('-').append(detailNo).append('-').append(oppAccNo).append('-').append(targetAmt.abs());
            } else {
                sBuffer.append(fixedAccNo).append('-').append(fixedDateStr).append('-').append(detailNo);
            }
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, fixedDateStr, receiptJson.toJSONString());
            detail.setJsonMap(receiptJson.toJSONString());
            Integer value = (Integer)countMap.get(receiptNo);
            if (value != null) {
                int count = value + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(detailNo);
            if ("HRMS".equalsIgnoreCase(trFrom)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"VouhNo", (String)PostScript);
            }
            StringBuilder bizNoBuffer = new StringBuilder();
            bizNoBuffer.append(dateStr).append(detailNo);
            DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)bizNoBuffer.toString());
            detailList.add(detail);
        }
        return detailList;
    }

    private static boolean isTransUp(String abs) {
        return "1023".equalsIgnoreCase(abs) || "1025".equalsIgnoreCase(abs) || "1022".equalsIgnoreCase(abs) || "1055".equalsIgnoreCase(abs);
    }

    private static boolean isTransDown(String abs) {
        return "1024".equalsIgnoreCase(abs) || "1026".equalsIgnoreCase(abs) || "1021".equalsIgnoreCase(abs) || "1056".equalsIgnoreCase(abs);
    }

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }
}

