/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.financing.query;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.business.financing.atomic.AbstractQueryFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IQueryFinancing;
import kd.ebg.aqap.business.financing.bank.BankQueryFinancingDetailRequest;
import kd.ebg.aqap.business.financing.bank.EBBankQueryFinancingDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingBankField;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryFinancingDetailImpl
extends AbstractQueryFinancingImpl
implements IQueryFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryFinancingDetailImpl.class);

    public EBBankQueryFinancingDetailResponse doBiz(BankQueryFinancingDetailRequest rqst) {
        ArrayList result = new ArrayList(1);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankQueryFinancingDetailResponse response = super.process(rqst);
            result.addAll(response.getDetails());
        }
        return new EBBankQueryFinancingDetailResponse(result);
    }

    public String pack(BankQueryFinancingDetailRequest request) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQLC97", Sequence.genSequence());
        String contLast = RequestContextUtils.getRunningParam((String)"contLast");
        String contFlag = RequestContextUtils.getRunningParam((String)"contFlag");
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"ContLast", (String)(StringUtils.isNotEmpty((String)contLast) ? contLast : ""));
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"PrdNo", (String)(StringUtils.isNotEmpty((String)request.getProductCode()) ? request.getProductCode() : ""));
        JDomUtils.addChild((Element)corp, (String)"RitCod", (String)"00");
        JDomUtils.addChild((Element)corp, (String)"ActInf", (String)"9");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"ContFlag", (String)(StringUtils.isNotEmpty((String)contFlag) ? contFlag : ""));
        String result = ABC_DC_Packer.covert2ABCMessage(root);
        this.logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)result);
        return result;
    }

    public EBBankQueryFinancingDetailResponse parse(BankQueryFinancingDetailRequest request, String rspStr) {
        ArrayList<FinancingProductDetail> detailList = new ArrayList<FinancingProductDetail>(16);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (ResManager.loadKDString((String)"\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"QueryFinancingDetailImpl_43", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]).equalsIgnoreCase(RespInfo)) {
            return new EBBankQueryFinancingDetailResponse(detailList);
        }
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u7406\u8d22\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de :%1$s %2$s\u3002", (String)"QueryFinancingDetailImpl_44", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cmp = root.getChild("Cmp");
        Element cme = root.getChild("Cme");
        String contLast = cme.getChildTextTrim("ContLast");
        String contFlag = ParserUtils.checkUnNullableElement((Element)cmp, (String)"ContFlag");
        if (StringUtils.isEmpty((String)contLast) || "0".equals(contFlag)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            RequestContextUtils.setRunningParam((String)"contLast", (String)contLast);
            RequestContextUtils.setRunningParam((String)"contFlag", (String)contFlag);
        }
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return new EBBankQueryFinancingDetailResponse(detailList);
        }
        String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        String[] splits = ResponseFileUtils.getDetailRspRecords(fileName, "");
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = 0; i < recordNum; ++i) {
            String PrdNo = splits[fieldNum * i + 4];
            String DbCur = splits[fieldNum * i + 5];
            String PrdNam = splits[fieldNum * i + 6];
            String RskLvl = splits[fieldNum * i + 7];
            String ProfitType = splits[fieldNum * i + 8];
            String PrdDueDes = splits[fieldNum * i + 9];
            String ExpectDes = splits[fieldNum * i + 10];
            String StartDate = splits[fieldNum * i + 11];
            String EndDate = splits[fieldNum * i + 12];
            String PrdSaleSta = splits[fieldNum * i + 14];
            String PrdBrand = splits[fieldNum * i + 19];
            String SaleFrom = splits[fieldNum * i + 20];
            String MStartDate = splits[fieldNum * i + 21];
            String MEndDate = splits[fieldNum * i + 22];
            String MStartTime = splits[fieldNum * i + 23];
            String MStopTime = splits[fieldNum * i + 24];
            String SStartDate = splits[fieldNum * i + 25];
            String SEndDate = splits[fieldNum * i + 26];
            String SStartTime = splits[fieldNum * i + 27];
            String SEndTime = splits[fieldNum * i + 28];
            String CashAmt = splits[fieldNum * i + 29];
            String PurchaseAmt = splits[fieldNum * i + 30];
            String StartAmt = splits[fieldNum * i + 31];
            String StepAmt = splits[fieldNum * i + 32];
            String TipAmt = splits[fieldNum * i + 33];
            String PurchaseStepAmt = splits[fieldNum * i + 34];
            String BuyStartAmt = splits[fieldNum * i + 35];
            String BuyStepAmt = splits[fieldNum * i + 36];
            String BuyTipAmt = splits[fieldNum * i + 37];
            String SubscribStatus = splits[fieldNum * i + 44];
            String PurchaseStatus = splits[fieldNum * i + 45];
            String RedeemStatus = splits[fieldNum * i + 46];
            String MktDate = splits[fieldNum * i + 47];
            String MktType = splits[fieldNum * i + 48];
            String UnitValue = splits[fieldNum * i + 49];
            String TotValue = splits[fieldNum * i + 50];
            String UnitBons = splits[fieldNum * i + 51];
            String PftValue = splits[fieldNum * i + 52];
            String DaysValue = splits[fieldNum * i + 53];
            String RgeValue = splits[fieldNum * i + 54];
            String TotRegValue = splits[fieldNum * i + 55];
            String YearValue = splits[fieldNum * i + 56];
            String TotYearValue = splits[fieldNum * i + 57];
            String CstnValue = splits[fieldNum * i + 58];
            String TotCstnValue = splits[fieldNum * i + 59];
            String MktBase = splits[fieldNum * i + 62];
            String PrdOrg = splits[fieldNum * i + 64];
            FinancingProductDetail detail = new FinancingProductDetail();
            detailList.add(detail);
            detail.setBankLoginID(request.getBankLoginID());
            detail.setBankVersionID(request.getBankVersionID());
            detail.setProductCode(PrdNo);
            detail.setProductName(PrdNam);
            detail.setCurrency(DbCur);
            detail.setPublishStartDate(null);
            detail.setPublishEndDate(null);
            detail.setBuyPrice(CashAmt);
            detail.setRedeemMax(BuyTipAmt);
            detail.setRedeemMin(BuyStartAmt);
            detail.setRiskLev(RskLvl);
            ArrayList<FinancingBankField> bankFields = new ArrayList<FinancingBankField>(16);
            detail.setBankFields(bankFields);
            bankFields.add(new FinancingBankField("PrdDueDes", PrdDueDes, ResManager.loadKDString((String)"\u4ea7\u54c1\u671f\u9650", (String)"QueryFinancingDetailImpl_45", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("ExpectDes", ExpectDes, ResManager.loadKDString((String)"\u9884\u671f\u5e74\u5316\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_46", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("StartDate", StartDate, ResManager.loadKDString((String)"\u8d77\u606f\u65e5", (String)"QueryFinancingDetailImpl_47", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("EndDate", EndDate, ResManager.loadKDString((String)"\u5230\u671f\u65e5", (String)"QueryFinancingDetailImpl_48", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("SStartDate", SStartDate, ResManager.loadKDString((String)"\u7533\u8d2d\u671f\u5f00\u59cb\u65e5\u671f", (String)"QueryFinancingDetailImpl_49", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("SEndDate", SEndDate, ResManager.loadKDString((String)"\u7533\u8d2d\u671f\u7ed3\u675f\u65e5\u671f", (String)"QueryFinancingDetailImpl_50", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("SStartTime", SStartTime, ResManager.loadKDString((String)"\u7533\u8d2d\u671f\u5f00\u59cb\u65f6\u95f4", (String)"QueryFinancingDetailImpl_51", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("SEndTime", SEndTime, ResManager.loadKDString((String)"\u7533\u8d2d\u671f\u7ed3\u675f\u65f6\u95f4", (String)"QueryFinancingDetailImpl_52", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("BuyStepAmt", BuyStepAmt, ResManager.loadKDString((String)"\u8d4e\u56de\u9012\u589e\u91d1\u989d", (String)"QueryFinancingDetailImpl_53", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("SubscribStatus", SubscribStatus, ResManager.loadKDString((String)"\u8ba4\u8d2d\u72b6\u6001", (String)"QueryFinancingDetailImpl_54", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("PurchaseStatus", PurchaseStatus, ResManager.loadKDString((String)"\u7533\u8d2d\u72b6\u6001", (String)"QueryFinancingDetailImpl_55", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("RedeemStatus", RedeemStatus, ResManager.loadKDString((String)"\u8d4e\u56de\u72b6\u6001", (String)"QueryFinancingDetailImpl_56", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("PrdOrg", PrdOrg, ResManager.loadKDString((String)"\u53d1\u884c\u673a\u6784", (String)"QueryFinancingDetailImpl_57", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("ProfitType", ProfitType, ResManager.loadKDString((String)"\u6536\u76ca\u7c7b\u578b", (String)"QueryFinancingDetailImpl_58", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("PrdSaleSta", PrdSaleSta, ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001", (String)"QueryFinancingDetailImpl_59", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("PrdBrand", PrdBrand, ResManager.loadKDString((String)"\u4ea7\u54c1\u54c1\u724c\u540d\u79f0", (String)"QueryFinancingDetailImpl_60", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("SaleFrom", SaleFrom, ResManager.loadKDString((String)"\u53d1\u552e\u6e20\u9053", (String)"QueryFinancingDetailImpl_61", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("MStartDate", MStartDate, ResManager.loadKDString((String)"\u52df\u96c6\u671f\u5f00\u59cb\u65e5\u671f", (String)"QueryFinancingDetailImpl_62", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("MEndDate", MEndDate, ResManager.loadKDString((String)"\u52df\u96c6\u671f\u7ed3\u675f\u65e5\u671f", (String)"QueryFinancingDetailImpl_63", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("MStartTime", MStartTime, ResManager.loadKDString((String)"\u52df\u96c6\u671f\u5f00\u59cb\u65f6\u95f4", (String)"QueryFinancingDetailImpl_64", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("MStopTime", MStopTime, ResManager.loadKDString((String)"\u52df\u96c6\u671f\u7ed3\u675f\u65f6\u95f4", (String)"QueryFinancingDetailImpl_65", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("PurchaseAmt", PurchaseAmt, ResManager.loadKDString((String)"\u7533\u8d2d\u53c2\u8003\u4ef7\u683c", (String)"QueryFinancingDetailImpl_66", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("StartAmt", StartAmt, ResManager.loadKDString((String)"\u5bf9\u516c\u8d77\u70b9\u91d1\u989d", (String)"QueryFinancingDetailImpl_67", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("StepAmt", StepAmt, ResManager.loadKDString((String)"\u5bf9\u516c\u9012\u589e\u91d1\u989d", (String)"QueryFinancingDetailImpl_68", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("TipAmt", TipAmt, ResManager.loadKDString((String)"\u5bf9\u516c\u5355\u7b14\u6700\u9ad8\u9650\u989d", (String)"QueryFinancingDetailImpl_69", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("PurchaseStepAmt", PurchaseStepAmt, ResManager.loadKDString((String)"\u7533\u8d2d\u8ffd\u52a0\u8d77\u70b9\u91d1\u989d", (String)"QueryFinancingDetailImpl_70", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("MktDate", MktDate, ResManager.loadKDString((String)"\u884c\u60c5\u65e5\u671f", (String)"QueryFinancingDetailImpl_71", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("MktType", MktType, ResManager.loadKDString((String)"\u884c\u60c5\u7c7b\u578b", (String)"QueryFinancingDetailImpl_72", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("UnitValue", UnitValue, ResManager.loadKDString((String)"\u5355\u4f4d\u51c0\u503c", (String)"QueryFinancingDetailImpl_73", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("TotValue", TotValue, ResManager.loadKDString((String)"\u7d2f\u8ba1\u51c0\u503c", (String)"QueryFinancingDetailImpl_74", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("UnitBons", UnitBons, ResManager.loadKDString((String)"\u7d2f\u8ba1\u5355\u4f4d\u5206\u7ea2", (String)"QueryFinancingDetailImpl_75", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("PftValue", PftValue, ResManager.loadKDString((String)"\u6bcf\u4e07\u4efd\u6536\u76ca", (String)"QueryFinancingDetailImpl_76", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("DaysValue", DaysValue, ResManager.loadKDString((String)"\u4e03\u65e5\u5e74\u5316\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_77", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("RgeValue", RgeValue, ResManager.loadKDString((String)"\u533a\u95f4\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_78", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("TotRegValue", TotRegValue, ResManager.loadKDString((String)"\u7d2f\u8ba1\u533a\u95f4\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_79", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("YearValue", YearValue, ResManager.loadKDString((String)"\u672c\u5e74\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_80", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("TotYearValue", TotYearValue, ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_81", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("CstnValue", CstnValue, ResManager.loadKDString((String)"\u6210\u7acb\u4ee5\u6765\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_82", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("TotCstnValue", TotCstnValue, ResManager.loadKDString((String)"\u6210\u7acb\u4ee5\u6765\u7d2f\u8ba1\u6536\u76ca\u7387", (String)"QueryFinancingDetailImpl_83", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            bankFields.add(new FinancingBankField("MktBase", MktBase, ResManager.loadKDString((String)"\u4e1a\u7ee9\u57fa\u51c6", (String)"QueryFinancingDetailImpl_84", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        }
        return new EBBankQueryFinancingDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "CQLC97";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7406\u8d22\u4ea7\u54c1\u4fe1\u606f", (String)"QueryFinancingDetailImpl_85", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankQueryFinancingDetailRequest bankQueryFinancingDetailRequest) {
        return true;
    }
}

