/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.agent;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.WaitFlagHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.agent.AgentQueryPayImpl;
import kd.ebg.aqap.banks.abc.dc.utils.MessageUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AgentPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AgentQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT07", paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)root, (String)"Amt", (String)(paymentInfo.getAmount() + ""));
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"DbLogAccNo", (String)"");
        String incomeAccNo = paymentInfo.getIncomeAccNo();
        String CrLogAccNo = null;
        if (paymentInfo.is2SameBank()) {
            if (incomeAccNo.length() == 27) {
                CrLogAccNo = incomeAccNo.substring(17);
                incomeAccNo = incomeAccNo.substring(2, 17);
            } else if (incomeAccNo.length() == 25) {
                CrLogAccNo = incomeAccNo.substring(15);
                incomeAccNo = incomeAccNo.substring(0, 15);
            } else {
                incomeAccNo = AcntNumberHelper.fixAccNoTo15Or19(incomeAccNo);
            }
        }
        JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)incomeAccNo);
        JDomUtils.addChild((Element)cmp, (String)"CrLogAccNo", (String)CrLogAccNo);
        JDomUtils.addChild((Element)cmp, (String)"CrCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"ConFlag", (String)"1");
        if (paymentInfo.is2SameBank() && incomeAccNo.length() != 19) {
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, true));
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        Element corp = ABC_DC_Packer.packCorp(root);
        JDomUtils.addChild((Element)corp, (String)"UrgencyFlag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        boolean flag = BankBusinessConfig.isInnerPoolTransfer(paymentInfo.getAccNo(), incomeAccNo);
        if (paymentInfo.is2SameBank() && flag) {
            JDomUtils.addChild((Element)corp, (String)"OthBankFlag", (String)"1");
        } else {
            JDomUtils.addChild((Element)corp, (String)"OthBankFlag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        }
        JDomUtils.addChild((Element)corp, (String)"DbBankName", (String)paymentInfo.getBankName());
        JDomUtils.addChild((Element)corp, (String)"CrAccName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)corp, (String)"CrBankName", (String)paymentInfo.getIncomeBankName());
        if (!paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)corp, (String)"CrBankNo", (String)paymentInfo.getIncomeCnaps());
        }
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)paymentInfo.getAccName());
        if (BankBusinessConfig.isWaitFlag()) {
            JDomUtils.addChild((Element)corp, (String)"WaitFlag", (String)"1");
        } else {
            JDomUtils.addChild((Element)corp, (String)"WaitFlag", (String)"0");
        }
        JDomUtils.addChild((Element)corp, (String)"SubAccNo", (String)paymentInfo.getAgentAccNo());
        JDomUtils.addChild((Element)corp, (String)"SubAccName", (String)paymentInfo.getAgentAccName());
        String exp = paymentInfo.getExplanation();
        JDomUtils.addChild((Element)corp, (String)"Postscript", (String)MessageUtil.getFixedPostScript(exp, 29));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StringUtils.isEmpty((String)rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u4e0d\u5b58\u5728RespCode\u8282\u70b9\u6216\u8be5\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        String WaitFlag = ABC_DC_Parser.parseWaitFlagMsg(root);
        if (!StringUtils.isEmpty((String)WaitFlag)) {
            WaitFlagHelper.parseWaitFlag(root, paymentInfo);
        }
        if ("0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u519c\u884c\u5df2\u53d7\u7406", (String)"CompanyPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)WaitFlag);
        } else if ("9999".equals(rsp.getResponseCode()) || "CICS".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u5b9a", (String)"CompanyPayImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u3002", (String)"CompanyPayImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRT07";
    }

    public String getBizDesc() {
        return "agentPay";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

