/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.batch;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.ABCBankResponse;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.BatchPayConstants;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileUtil;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBatchPayParser {
    private static final Logger logger = LoggerFactory.getLogger(QueryBatchPayParser.class);

    public static void parseQueryBatchPayString(PaymentInfo[] infos, String rsp, String bizSeqId) {
        Element root = ABC_DC_Parser.parseString2Root(rsp);
        BankResponse bankResponse = ABC_DC_Parser.parseHeader(root);
        String fileFlag = JDomUtils.getChildText((Element)root, (String)"FileFlag");
        String rspSource = JDomUtils.getChildText((Element)root, (String)"RespSource");
        if (!StrUtil.isEmpty((String)rspSource) && !"0".equalsIgnoreCase(rspSource) && "0".equalsIgnoreCase(fileFlag)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryBatchPayParser_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return;
        }
        String type = JDomUtils.getChildText((Element)root, (String)"TransType");
        if (StringUtils.isEmpty((String)type)) {
            type = "";
        }
        Element cmp = JDomUtils.getChildElement((Element)root, (String)"Cmp");
        String fileName = JDomUtils.getChildText((Element)cmp, (String)"BatchFileName");
        Element batchPlat = JDomUtils.getChildElement((Element)root, (String)"BatchPlat");
        String status = "";
        String subStatus = "";
        String desc = "";
        if (null != batchPlat) {
            Element batch = JDomUtils.getChildElement((Element)batchPlat, (String)ResManager.loadKDString((String)"\u6279\u5904\u7406", (String)"QueryBatchPayParser_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            status = JDomUtils.getChildText((Element)batch, (String)ResManager.loadKDString((String)"\u72b6\u6001", (String)"QueryBatchPayParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            subStatus = JDomUtils.getChildText((Element)batch, (String)ResManager.loadKDString((String)"\u5b50\u72b6\u6001", (String)"QueryBatchPayParser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            desc = JDomUtils.getChildText((Element)batch, (String)ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"QueryBatchPayParser_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        if ("1".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryBatchPayParser_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)subStatus, (String)desc);
        } else if ("5".equalsIgnoreCase(subStatus) || "1".equalsIgnoreCase(fileFlag)) {
            String fileContent = "";
            try {
                logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0b\u8f7d\u5f00\u59cb:\u6587\u4ef6\u540d={}", (Object)fileName);
                fileContent = new ABC_DCFileUtil().downloadFile(fileName, bizSeqId);
                logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
                logger.info(fileContent);
            }
            catch (Exception e) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u4ea4\u6613\u7ed3\u679c\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (String)"QueryBatchPayParser_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)subStatus, (String)desc);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0b\u8f7d%1$s\u5931\u8d25\u3002", (String)"QueryBatchPayParser_16", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), fileName), (Throwable)e);
            }
            String[] content = QueryBatchPayParser.getSpitedStrings(fileContent, BatchPayConstants.getSeperator(type));
            Integer recordNum = 0;
            Element cme = JDomUtils.getChildElement((Element)root, (String)"Cme");
            String recordNumsString = JDomUtils.getChildText((Element)cme, (String)"RecordNum");
            if (!StrUtil.isEmpty((String)recordNumsString)) {
                recordNum = Integer.parseInt(recordNumsString);
            }
            Map<String, ABCBankResponse> resultMap = QueryBatchPayParser.getStatusMap(content, type, recordNum);
            for (PaymentInfo info : infos) {
                ABCBankResponse response = resultMap.get(info.getBankDetailSeqId());
                if (null == response) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u672a\u8fd4\u56de\u672c\u6761\u8bb0\u5f55\uff0c\u72b6\u6001\u672a\u77e5\u3002", (String)"QueryBatchPayParser_9", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)"");
                    continue;
                }
                if (response.isSuccess() == 1) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"QueryBatchPayParser_10", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if (response.isSuccess() == -1) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5931\u8d25", (String)"QueryBatchPayParser_11", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if ("6".equals(response.getStatusCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u8fd4\u56de\u72b6\u6001\u672a\u77e5\u3002", (String)"QueryBatchPayParser_12", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)ResManager.loadKDString((String)"\u843d\u5730\u5f85\u5904\u7406", (String)"QueryBatchPayParser_13", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u8fd4\u56de\u72b6\u6001\u672a\u77e5\u3002", (String)"QueryBatchPayParser_12", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u65e0\u6cd5\u5f85\u786e\u8ba4\u3002", (String)"QueryBatchPayParser_14", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)subStatus, (String)desc);
        }
    }

    private static String[] getSpitedStrings(String content, String seperator) {
        String[] reuslt = null;
        reuslt = StringUtils.split((String)content, (String)seperator);
        return reuslt;
    }

    public static Map<String, ABCBankResponse> getStatusMap(String[] content, String type, int recordNum) {
        HashMap<String, ABCBankResponse> resultMap = new HashMap<String, ABCBankResponse>();
        for (int i = 0; i < recordNum; ++i) {
            String custNo = "";
            String status = "";
            String bankCode = "";
            String bankMsg = "";
            int rowNum = 13;
            ABCBankResponse response = null;
            if ("IBBF01".equalsIgnoreCase(type)) {
                rowNum = 15;
                custNo = content[i * rowNum];
                status = content[i * rowNum + 12];
                bankCode = content[i * rowNum + 13];
                bankMsg = content[i * rowNum + 14];
                response = new ABCBankResponse();
            } else if ("IBBF23".equalsIgnoreCase(type)) {
                rowNum = 11;
                custNo = content[i * rowNum + 1];
                status = content[i * rowNum + 6];
                bankCode = content[i * rowNum + 6];
                bankMsg = content[i * rowNum + 7];
                response = new ABCBankResponse();
            } else if ("IBBF02".equalsIgnoreCase(type)) {
                rowNum = 14;
                custNo = content[i * rowNum];
                status = content[i * rowNum + 11];
                bankCode = content[i * rowNum + 12];
                bankMsg = content[i * rowNum + 13];
                response = new ABCBankResponse();
            }
            if (response == null || status == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"response\u548cstatus\u4e3anull\u3002", (String)"QueryBatchPayParser_15", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            }
            response.setSuccess(status);
            response.setResponseCode(bankCode);
            response.setResponseMessage(bankMsg);
            if (StrUtil.isEmpty((String)custNo)) continue;
            resultMap.put(custNo, response);
        }
        return resultMap;
    }
}

