/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary;

import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryPacker;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryParser;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CFRT03";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44, \u4ee3\u53d1\u5de5\u8d44-\u519c\u884c\u8d26\u6237(CFRT03)", (String)"SalaryPayImpl_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    public EBBankPayResponse pay(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String salaryMsg = null;
        IConnection conn = null;
        try {
            salaryMsg = new SalaryPacker().packPay(paymentInfos);
            SalaryHelper.createSalaryPaymentFile(paymentInfos);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream outputStream = conn.getOutputStream();){
                String recvMsg = SalaryHelper.sendAndRecvMessage(conn, outputStream, salaryMsg);
                new SalaryParser().parsePay(paymentInfos, recvMsg);
            }
        }
        catch (Throwable t) {
            EBContext.getContext().setThrowableAfterSend(t);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String pack(BankPayRequest request) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return null;
    }
}

