/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary;

import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryPacker;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.util.IOUtils;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 100;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CQRT01,CQLT19";
    }

    public String getBizDesc() {
        return "";
    }

    public EBBankPayResponse queryPay(BankPayRequest request) {
        String bizSeqId = request.getHeader().getBizSeqID();
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        for (int i = 0; i < paymentInfos.length; ++i) {
            try {
                String icsSequence = this.querySalaryTranResult_CQRT01(paymentInfos[i], bizSeqId);
                if (null == icsSequence) continue;
                this.queryMidBizDetailResult_CQLT19(paymentInfos[i], icsSequence, bizSeqId);
                continue;
            }
            catch (Exception e) {
                paymentInfos[i].setStatusMsg(e.getMessage());
                paymentInfos[i].setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                paymentInfos[i].setStatusName(PaymentState.UNKNOWN.getEnName());
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    private String querySalaryTranResult_CQRT01(PaymentInfo paymentInfo, String bizSeqId) {
        try {
            String packageId = paymentInfo.getBankDetailSeqId();
            String date = packageId.substring(0, packageId.indexOf(95));
            String queryMsg = null;
            try {
                queryMsg = new SalaryPacker().createSalaryTranResultRequest_CQRT01(date);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6784\u9020\u67e5\u8be2\u4ee3\u6536\u4ee3\u4ed8\u4ea4\u6613\u7ed3\u679c\u8bf7\u6c42\u62a5\u6587\u5f02\u5e38\u3002", (String)"SalaryQueryPayImpl_13", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
            }
            String recvMsg = SalaryHelper.sendAndRecvMessage(queryMsg);
            return new SalaryParser().parseSalaryTranResultRsp(paymentInfo, recvMsg, bizSeqId);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private void queryMidBizDetailResult_CQLT19(PaymentInfo paymentInfo, String icsSequence, String bizSeqId) {
        try {
            String queryMsg = null;
            try {
                queryMsg = new SalaryPacker().createMidBizDetailResultRequest_CQLT19(icsSequence);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6784\u9020\u67e5\u8be2\u4e2d\u95f4\u4e1a\u52a1\u660e\u7ec6\u5904\u7406\u7ed3\u679c\u8bf7\u6c42\u62a5\u6587\u5f02\u5e38\u3002", (String)"SalaryQueryPayImpl_14", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
            }
            String recvMsg = SalaryHelper.sendAndRecvMessage(queryMsg);
            new SalaryParser().parseMidBizDetailResultRsp(paymentInfo, recvMsg, bizSeqId);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankPayRequest request) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return null;
    }
}

