/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.oversea;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.oversea.GQLT16QueryPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.oversea.PayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GFRB10PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return GQLT16QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = ABC_DC_Packer.createABCRoot4New(this.getBizCode(), paymentInfo.getBankDetailSeqId());
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        String amout = paymentInfo.getAmount().setScale(2, 4).toString();
        JDomUtils.addChild((Element)root, (String)"Amt", (String)amout);
        JDomUtils.addChild((Element)root, (String)"ccy", (String)paymentInfo.getPayCurrency());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)paymentInfo.getIncomeAccNo());
        Element biz = JDomUtils.addChild((Element)root, (String)"biz");
        JDomUtils.addChild((Element)biz, (String)"ac_type", (String)BankBusinessConfig.getOverseaAccType(paymentInfo.getAccNo()));
        boolean isForeign = false;
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        if (code != null && !code.geteChart3().equalsIgnoreCase("CHN")) {
            isForeign = true;
        }
        String rem_way = "";
        rem_way = isForeign ? "1" : (paymentInfo.getIncomeCity().contains(PropertiesConstants.getValue((String)"AcntNumberHelper_34")) ? (paymentInfo.is2SameBank() ? "3" : "4") : (paymentInfo.is2SameBank() ? "5" : "6"));
        JDomUtils.addChild((Element)biz, (String)"rem_way", (String)rem_way);
        String feeMode = "O";
        if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "B";
        } else if ("03".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "S";
        }
        JDomUtils.addChild((Element)biz, (String)"charges_details", (String)feeMode);
        JDomUtils.addChild((Element)biz, (String)"beneficiary", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)biz, (String)"bene_addr1", (String)paymentInfo.getIncomeAddress());
        JDomUtils.addChild((Element)biz, (String)"bene_addr2", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)biz, (String)"ac_bank_fld", (String)"A");
        JDomUtils.addChild((Element)biz, (String)"ac_bank_name", (String)ABC_DC_Packer.checkNotNull(paymentInfo.getIncomeSwiftCode(), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9swift code\u4e0d\u80fd\u4e3a\u7a7a", (String)"GFRB10PayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        JDomUtils.addChild((Element)biz, (String)"int_bank_fld", (String)"");
        JDomUtils.addChild((Element)biz, (String)"int_bank_name", (String)"");
        JDomUtils.addChild((Element)biz, (String)"bene_type", (String)(paymentInfo.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)biz, (String)"pay_details", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)biz, (String)"postscript", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)biz, (String)"usage", (String)ABC_DC_Packer.checkNotNull(paymentInfo.getBusinessTypeCode(), ResManager.loadKDString((String)"\u6c47\u6b3e\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a", (String)"GFRB10PayImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        JDomUtils.addChild((Element)biz, (String)"country", (String)(code != null ? code.geteChart3() : ""));
        String pay_type = "O";
        if ("1".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            pay_type = "P";
        } else if ("0".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            pay_type = "A";
        } else if ("2".equalsIgnoreCase(paymentInfo.getPayProperty())) {
            pay_type = "R";
        }
        JDomUtils.addChild((Element)biz, (String)"pay_type", (String)pay_type);
        JDomUtils.addChild((Element)biz, (String)"pay_attr", (String)ABC_DC_Packer.checkNotNull(paymentInfo.getPayAttribute(), ResManager.loadKDString((String)"\u7533\u62a5\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GFRB10PayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        JDomUtils.addChild((Element)biz, (String)"tx_code1", (String)paymentInfo.getTxCode());
        JDomUtils.addChild((Element)biz, (String)"tc_amt1", (String)paymentInfo.getTxAmount());
        JDomUtils.addChild((Element)biz, (String)"tx_rem1", (String)paymentInfo.getTxPostscript());
        JDomUtils.addChild((Element)biz, (String)"is_ref", (String)(paymentInfo.isBondGoodsFlag() ? "Y" : "N"));
        JDomUtils.addChild((Element)biz, (String)"crt_user", (String)ABC_DC_Packer.checkNotNull(paymentInfo.getApplyName(), ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"GFRB10PayImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        JDomUtils.addChild((Element)biz, (String)"inp_telc", (String)ABC_DC_Packer.checkNotNull(paymentInfo.getApplyPhone(), ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (String)"GFRB10PayImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
        JDomUtils.addChild((Element)biz, (String)"contr_no", (String)paymentInfo.getContractNo());
        JDomUtils.addChild((Element)biz, (String)"invoi_no", (String)paymentInfo.getInvoiceNo());
        JDomUtils.addChild((Element)biz, (String)"cap_accu_flag", (String)"0");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        String othBankFlag = "";
        othBankFlag = isForeign ? "2" : (paymentInfo.is2SameBank() ? "0" : "1");
        JDomUtils.addChild((Element)corp, (String)"OthBankFlag", (String)othBankFlag);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PayParser.parse(paymentInfos, responseStr);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GFRB10";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5916\u5e01\u6c47\u51fa\u6c47\u6b3e", (String)"GFRB10PayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

