/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public enum ErrorCode {
    ERROR("-1", "ERROR", new MultiLangEnumBridge("\u7a0b\u5e8f\u51fa\u9519\u4e86", "ErrorCode_0", "ebg-aqap-banks-glb-dc")),
    FORGED_TRANSACTIONS("EBLN9000", "Forged transactions, the transaction fails", new MultiLangEnumBridge("\u4f2a\u9020\u4ea4\u6613\u6570\u636e\uff0c\u4ea4\u6613\u5931\u8d25\u3002", "ErrorCode_1", "ebg-aqap-banks-glb-dc")),
    FIELD_NOT_ENTERED("EBLN9005", "  not entered the Required field", new MultiLangEnumBridge("\u5fc5\u8f93\u5b57\u6bb5\u672a\u8f93\u5165\u3002", "ErrorCode_2", "ebg-aqap-banks-glb-dc"));

    private String errorcode;
    private MultiLangEnumBridge cnName;
    private String enName;

    private ErrorCode(String errorcode, String enName, MultiLangEnumBridge cnName) {
        this.errorcode = errorcode;
        this.enName = enName;
        this.cnName = cnName;
    }

    public String getErrorCode() {
        return this.errorcode;
    }

    public String getCnName() {
        return this.cnName.loadKDString();
    }

    public String getEnName() {
        return this.enName;
    }

    public static ErrorCode getEnumByErrorCode(String errorcode) {
        for (ErrorCode state : ErrorCode.values()) {
            if (!state.getErrorCode().equalsIgnoreCase(errorcode)) continue;
            return state;
        }
        return ERROR;
    }

    public static String getEnumErrorCodeAndMessageByErrorCode(String errorcode) {
        for (ErrorCode state : ErrorCode.values()) {
            if (!state.getErrorCode().equalsIgnoreCase(errorcode)) continue;
            return String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7801\uff1a%s", (String)"ErrorCode_6", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), state.getErrorCode()) + String.format(ResManager.loadKDString((String)"---\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ErrorCode_7", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), state.getCnName());
        }
        return String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u9519\u8bef\u7801\uff1a%s\u3002", (String)"ErrorCode_8", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), errorcode);
    }

    public static ErrorCode getEnumByEnName(String enName) {
        for (ErrorCode state : ErrorCode.values()) {
            if (!state.getEnName().equals(enName)) continue;
            return state;
        }
        return ERROR;
    }

    public static ErrorCode getEnumByCnName(String cnName) {
        for (ErrorCode state : ErrorCode.values()) {
            if (!state.getCnName().equals(cnName)) continue;
            return state;
        }
        return ERROR;
    }
}

