/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.utils;

import java.text.ParseException;
import java.util.Date;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class GLBParser {
    public static Date parseGLBTrans(String timeStampStr) {
        try {
            return DateTimeUtils.parseDate((String)timeStampStr, (String)"yyyyMMddHH:mm:ss");
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static BankResponse parseHeader(Element head) {
        BankResponse rsp = new BankResponse();
        String retCode = head.getChildTextTrim("retCode");
        String retMsg = "";
        Element RetMsgElement = head.getChild("retMessage");
        if (RetMsgElement != null) {
            String retMessage = GLBParser.e2StrPlain(RetMsgElement, "GBK");
            int start = retMessage.indexOf("<retMessage>");
            int end = retMessage.indexOf("</retMessage>", start);
            retMsg = retMessage.substring(start + "<retMessage>".length(), end);
        }
        rsp.setResponseCode(retCode);
        rsp.setResponseMessage(StringUtils.catWithSpace((String[])new String[]{retCode, retMsg}));
        return rsp;
    }

    private static String e2StrPlain(Element element, String encoding) {
        XMLOutputter outputter = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setEncoding(encoding);
        format.setIndent("");
        format.setLineSeparator("");
        format.setExpandEmptyElements(true);
        outputter.setFormat(format);
        return outputter.outputString(element).trim();
    }
}

