/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccqtgb.dc.services.helper;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.BankCode;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DC_RequestPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DC_RequestPacker.class);

    public static Element createCommonHead(String transCode, String serialNumber) {
        Element element = new Element("Head");
        JDomUtils.addChild((Element)element, (String)"TrsCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (serialNumber != null && !serialNumber.isEmpty()) {
            JDomUtils.addChild((Element)element, (String)"ERPJnlNo", (String)serialNumber);
        }
        return element;
    }

    public static String getBalanceMessageFYI(BankAcnt bankAcnt) {
        String reqStr;
        try {
            Element message = new Element("Message");
            Element head = DC_RequestPacker.createCommonHead(BankCode.BANLANCE_CODE, null);
            Element body = new Element("Body");
            Element list = new Element("List");
            Element map = new Element("Map");
            JDomUtils.addChild((Element)message, (Element)head);
            JDomUtils.addChild((Element)message, (Element)body);
            JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankAcnt.getAccNo());
            JDomUtils.addChild((Element)list, (Element)map);
            JDomUtils.addChild((Element)body, (Element)list);
            reqStr = JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
        }
        catch (Exception exception) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6253\u5305\u62a5\u6587\u51fa\u9519", (String)"DC_RequestPacker_0", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), (Throwable)exception);
        }
        return reqStr;
    }

    public static String getDetailsMessageFYI(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate) {
        Element message = new Element("Message");
        Element head = DC_RequestPacker.createCommonHead(BankCode.DETAIL_CODE, null);
        Element body = new Element("Body");
        Element list = new Element("List");
        Element map = new Element("Map");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)map, (String)"Currency", (String)bankAcnt.getCurrency());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)startDate, (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)endDate, (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)list, (Element)map);
        JDomUtils.addChild((Element)body, (Element)list);
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public static String getSamePayMessageFYI(List<PaymentInfo> paymentInfoArray) {
        Element message = new Element("Message");
        String serialNo = paymentInfoArray.get(0).getBankBatchSeqID();
        Element head = DC_RequestPacker.createCommonHead(BankCode.INNER_TRANS_CODE, serialNo);
        Element body = new Element("Body");
        Element list = new Element("List");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        for (PaymentInfo payInfo : paymentInfoArray) {
            Element map = new Element("Map");
            JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)payInfo.getAccNo());
            JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)payInfo.getAccName());
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)payInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)payInfo.getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"Amount", (String)String.format("%.2f", payInfo.getAmount()));
            JDomUtils.addChild((Element)map, (String)"PayerCurrency", (String)payInfo.getCurrency());
            JDomUtils.addChild((Element)map, (String)"Remark", (String)(payInfo.getExplanation() + "KD@"));
            payInfo.setBankSerialNo(serialNo);
            JDomUtils.addChild((Element)list, (Element)map);
        }
        JDomUtils.addChild((Element)body, (Element)list);
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public static String getOtherPayMessageFYI(List<PaymentInfo> paymentInfoArray) {
        Element message = new Element("Message");
        String serialNo = Sequence.gen18Sequence();
        Element head = DC_RequestPacker.createCommonHead(BankCode.CROSSBANK_TRANS_CODE, paymentInfoArray.get(0).getBankBatchSeqID());
        Element body = new Element("Body");
        Element list = new Element("List");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        for (PaymentInfo payInfo : paymentInfoArray) {
            Element map = new Element("Map");
            JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)payInfo.getAccNo());
            JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)payInfo.getAccName());
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)payInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)payInfo.getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"Amount", (String)String.format("%.2f", payInfo.getAmount()));
            JDomUtils.addChild((Element)map, (String)"Currency", (String)payInfo.getCurrency());
            JDomUtils.addChild((Element)map, (String)"Remark", (String)payInfo.getExplanation());
            JDomUtils.addChild((Element)map, (String)"Drecode", (String)payInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)map, (String)"UnionDeptId", (String)payInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)map, (String)"PayeeBankName", (String)payInfo.getIncomeBankName());
            int priority = 1;
            if (payInfo.is2Urgent()) {
                priority = 0;
            }
            JDomUtils.addChild((Element)map, (String)"Priority", (String)(priority + ""));
            JDomUtils.addChild((Element)list, (Element)map);
        }
        JDomUtils.addChild((Element)body, (Element)list);
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public static String getQueryPayMessageFYI(PaymentInfo[] paymentInfos) {
        String serialNo = Sequence.gen18Sequence();
        Element message = new Element("Message");
        Element head = DC_RequestPacker.createCommonHead(BankCode.STAT_CODE, serialNo);
        Element body = new Element("Body");
        Element list = new Element("List");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        for (PaymentInfo payInfo : paymentInfos) {
            Element map = new Element("Map");
            JDomUtils.addChild((Element)map, (String)"OldJnlNo", (String)payInfo.getBankBatchSeqID());
            JDomUtils.addChild((Element)map, (String)"OldTrsDate", (String)LocalDateUtil.formatDate((LocalDate)payInfo.getSubmitSuccessTime().toLocalDate(), (String)"yyyy-MM-dd"));
            JDomUtils.addChild((Element)map, (String)"PayAcnt", (String)payInfo.getAccNo());
            JDomUtils.addChild((Element)map, (String)"RcvAcnt", (String)payInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"Amount", (String)String.format("%.2f", payInfo.getAmount()));
            JDomUtils.addChild((Element)list, (Element)map);
        }
        JDomUtils.addChild((Element)body, (Element)list);
        String reqStr = JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
        return reqStr;
    }
}

