/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccqtgb.dc.services.payment.batch;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.BankCode;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.DC_RequestPacker;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.DC_ResponseParser;
import kd.ebg.aqap.banks.ccqtgb.dc.services.payment.batch.QueryBatchPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BatchPaymentImpl.class);

    public int getBatchSize() {
        return 400;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryBatchPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfoArray = bankPayRequest.getPaymentInfos();
        Element message = new Element("Message");
        Element head = DC_RequestPacker.createCommonHead(this.getBizCode(), ((PaymentInfo)paymentInfoArray.get(0)).getBankBatchSeqID());
        Element body = new Element("Body");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        Element list = new Element("List");
        JDomUtils.addChild((Element)body, (Element)list);
        Element map1 = new Element("Map");
        JDomUtils.addChild((Element)list, (Element)map1);
        JDomUtils.addChild((Element)map1, (String)"AcctNo", (String)bankPayRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)map1, (String)"TotalNum", (String)(bankPayRequest.getTotalCount() + ""));
        JDomUtils.addChild((Element)map1, (String)"TotalAmt", (String)String.format("%.2f", bankPayRequest.getTotalAmount()));
        Element list2 = new Element("List");
        JDomUtils.addChild((Element)map1, (Element)list2);
        int i = 1;
        for (PaymentInfo payInfo : paymentInfoArray) {
            Element map = new Element("Map");
            JDomUtils.addChild((Element)map, (String)"Number", (String)(i + ""));
            payInfo.setSys("Number", i + "");
            ++i;
            JDomUtils.addChild((Element)map, (String)"RcvAcct", (String)payInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"RcvAcctName", (String)payInfo.getIncomeAccName());
            if (payInfo.is2SameBank()) {
                JDomUtils.addChild((Element)map, (String)"RcvBankType", (String)"0");
            } else {
                JDomUtils.addChild((Element)map, (String)"RcvBankType", (String)"1");
            }
            JDomUtils.addChild((Element)map, (String)"TranAmt", (String)String.format("%.2f", payInfo.getAmount()));
            JDomUtils.addChild((Element)map, (String)"TranUsage", (String)payInfo.getExplanation());
            JDomUtils.addChild((Element)map, (String)"RcvBankJionNo", (String)payInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)map, (String)"ReservedField1", (String)"");
            JDomUtils.addChild((Element)map, (String)"ReservedField2", (String)"");
            JDomUtils.addChild((Element)map, (String)"ReservedField3", (String)"");
            JDomUtils.addChild((Element)list2, (Element)map);
        }
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse response = DC_ResponseParser.parserCommonHead(rspStr);
        if (!BankCode.SUCCESS_CODE.equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u975e\u6b63\u5e38\u7684\u5916\u5c42\u72b6\u6001\u7801\uff1a%s\u3002", (String)"BatchPaymentImpl_0", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]), response.getResponseCode()));
        }
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element bodyEle = root.getChild("Body");
        Element list = bodyEle.getChild("List");
        Element map = list.getChild("Map");
        String BatchNo = map.getChildText("BatchNo");
        String ReturnCode = map.getChildText("ReturnCode");
        String ReturnMsg = map.getChildText("ReturnMsg");
        if (StringUtils.isNotEmpty((String)BatchNo)) {
            EBGBusinessUtils.setBankRefId((List)paymentInfos, (String)BatchNo);
            if (BankCode.SUCCESS_CODE.equals(ReturnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ReturnCode, (String)ReturnMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ReturnMsg, (String)ReturnCode, (String)ReturnMsg);
            }
        } else if (BankCode.SUCCESS_CODE.equals(ReturnCode)) {
            this.logger.info("\u94f6\u884c\u672a\u8fd4\u56de\u6279\u6b21\u53f7\uff0c\u8fd4\u56de\u6210\u529f\u7801{}\uff0c\u76f4\u63a5\u6279\u91cf\u7f6e\u4e3a\u6210\u529f", (Object)ReturnCode);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)ReturnCode, (String)ReturnMsg);
        } else if (BankCode.FAIL_CODE.equals(ReturnCode)) {
            this.logger.info("\u94f6\u884c\u672a\u8fd4\u56de\u6279\u6b21\u53f7\uff0c\u8fd4\u56de\u5931\u8d25\u7801{}\uff0c\u76f4\u63a5\u6279\u91cf\u7f6e\u4e3a\u5931\u8d25", (Object)ReturnCode);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ReturnMsg, (String)ReturnCode, (String)ReturnMsg);
        } else {
            this.logger.info("\u94f6\u884c\u672a\u8fd4\u56de\u6279\u6b21\u53f7\uff0c\u8fd4\u56de\u7f16\u53f7{}\uff0c\u76f4\u63a5\u6279\u91cf\u7f6e\u4e3a\u672a\u786e\u8ba4", (Object)ReturnCode);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ReturnMsg, (String)ReturnCode, (String)ReturnMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return BankCode.BATCHCROSSBANK_TRANS_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u6279\u91cf\u8f6c\u8d26", (String)"BatchPaymentImpl_1", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !paymentInfo.is2SameBank();
    }
}

