/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.ecny.service.payment.etoe;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.ecny.service.Packer;
import kd.ebg.aqap.banks.boc.ecny.service.Parser;
import kd.ebg.aqap.banks.boc.ecny.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.ecny.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.ecny.service.payment.etoe.CompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(CompanyPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "b2e0675";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94b1\u5305\u8f6c\u8d26\u7533\u8bf7", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0675");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0675-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0675-rq");
            JDomUtils.addChild((Element)rq, (String)"insid", (String)paymentInfo.getBankBatchSeqId());
            Element fractn = JDomUtils.addChild((Element)rq, (String)"fractn");
            JDomUtils.addChild((Element)fractn, (String)"payerwalletid", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)fractn, (String)"payerwalletname", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)fractn, (String)"payersubwalletid", (String)"");
            Element toactn = JDomUtils.addChild((Element)rq, (String)"toactn");
            JDomUtils.addChild((Element)toactn, (String)"payeewalletid", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)toactn, (String)"payeewalletname", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)toactn, (String)"payeenam", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)toactn, (String)"payeewalletinstno", (String)paymentInfo.getIncomeBranchNo());
            JDomUtils.addChild((Element)rq, (String)"currency", (String)"CNY");
            JDomUtils.addChild((Element)rq, (String)"amount", (String)paymentInfo.getAmount().setScale(2, 4).toString());
            JDomUtils.addChild((Element)rq, (String)"useinf", (String)"");
            JDomUtils.addChild((Element)rq, (String)"remark", (String)paymentInfo.getExplanation());
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos);
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0675-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]), (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0675-rs");
        for (Element rs : list) {
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            String transstatus = rs.getChildText("transstatus");
            if ("B001".equals(another_rspcod)) {
                if ("A".equals(transstatus)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualPayImpl_5", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
                    continue;
                }
                if ("B".equals(transstatus)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualPayImpl_6", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualPayImpl_7", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPayImpl_4", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

