/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.ecny.service.detail;

import com.icbc.api.response.MybankEnterprisePayQdcdetailResponseV1;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.ecny.service.util.OppType;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

class DetailParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParser.class);

    DetailParser() {
    }

    public static List<DetailInfo> parse(BankDetailRequest rqst, MybankEnterprisePayQdcdetailResponseV1 response) {
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>();
        if (response.isSuccess()) {
            List responseRds = response.getRd();
            if (responseRds == null || responseRds.size() == 0) {
                return list;
            }
            for (MybankEnterprisePayQdcdetailResponseV1.MybankEnterprisePayQdcdetailResponseRdV1 rd : responseRds) {
                DetailInfo info = new DetailInfo();
                info.setAccNo(response.getAccountNo());
                info.setAccName(rqst.getAcnt().getAccName());
                info.setCurrency(rd.getCurrency());
                info.setOppAccNo(rd.getCpMediumNo());
                info.setOppAccName(rd.getRecipName());
                String type = rd.getCpType();
                String cashf = rd.getCashf();
                info.setOppBankName(OppType.INSTANCE.convert2Bank(type));
                String signDate4Test = RequestContextUtils.getBankParameterValue((String)"signDate4Test");
                if (StringUtils.isEmpty((String)signDate4Test)) {
                    try {
                        info.setTransDate(LocalDate.parse(rd.getBusiDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                        info.setTransTime(LocalDateTime.parse(rd.getBusiDate() + rd.getBusiTime(), DateTimeFormatter.ofPattern("yyyy-MM-ddHH:mm:ss")));
                    }
                    catch (Exception e) {
                        logger.error("\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e);
                    }
                } else {
                    try {
                        info.setTransDate(LocalDate.now());
                        String date = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
                        info.setTransTime(LocalDateTime.parse(date + rd.getBusiTime(), DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss")));
                    }
                    catch (Exception e) {
                        logger.error("\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e);
                    }
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"Date", (Object)rd.getBusiDate());
                jsonObject.put((Object)"Time", (Object)rd.getBusiTime());
                jsonObject.put((Object)"orderId", (Object)rd.getOrderId());
                jsonObject.put((Object)"relReqId", (Object)rd.getRelReqId());
                info.setJsonMap(jsonObject.toString());
                info.setExplanation(rd.getSummary() + "-" + rd.getRemark() + "-" + rd.getPostScript());
                Long payamt = rd.getTranAmount();
                BigDecimal totalFee = new BigDecimal(payamt);
                String loan = rd.getRpflag();
                if ("1".equals(loan)) {
                    info.setCreditAmount(BigDecimalHelper.div((BigDecimal)totalFee, (BigDecimal)new BigDecimal("100.00")));
                    info.setDebitAmount(BigDecimalHelper.ZERO);
                } else {
                    info.setDebitAmount(BigDecimalHelper.div((BigDecimal)totalFee, (BigDecimal)new BigDecimal("100.00")));
                    info.setCreditAmount(BigDecimalHelper.ZERO);
                }
                info.setBalance(rd.getBalance() == null ? BigDecimalHelper.ZERO : BigDecimalHelper.div((BigDecimal)new BigDecimal(rd.getBalance()), (BigDecimal)new BigDecimal("100.00")));
                list.add(info);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u3002\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceParser_3", (String)"ebg-aqap-banks-icbc-ecny", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
        }
        return list;
    }
}

