/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc.service.payment.individual.salary;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import kd.ebg.aqap.banks.xmb.dc.service.payment.individual.salary.QueryPayPacker;
import kd.ebg.aqap.banks.xmb.dc.service.payment.individual.salary.QueryPayPage;
import kd.ebg.aqap.banks.xmb.dc.service.payment.individual.salary.QueryPayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 500;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=GBK");
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse queryPay(BankPayRequest request) {
        QueryPayPage pageQuery = new QueryPayPage(1, 0);
        List paymentInfoList = request.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        while (true) {
            try {
                String rqstStr = new QueryPayPacker().packQueryPay(paymentInfos, pageQuery);
                ConnectionFactory factory = this.getConnectionFactory();
                factory.setHttpHeader("content-type", "application/xml; charset=GBK");
                IConnection conn = this.getConnection(factory);
                this.openConnection(conn);
                try (OutputStream os = this.getOutputStream(conn);){
                    this.send(os, rqstStr);
                    this.closeOutputStreamQuietly(os);
                    try (InputStream is = this.getInputStream(conn);){
                        String rspStr = this.recv(is);
                        this.closeInputStreamQuietly(is);
                        new QueryPayParser().parseQueryPay(paymentInfos, rspStr, pageQuery);
                    }
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            if (pageQuery.getCurrentNum() == pageQuery.getTotalRecord() || pageQuery.getCurrentNum() < 15) break;
            pageQuery.setStartPage(pageQuery.getStartPage() + 15);
        }
        return new EBBankPayResponse(Arrays.asList(paymentInfos));
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE014";
    }

    public String getBizDesc() {
        return null;
    }
}

