/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.services.payment.batch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wzb.opa.services.payment.batch.QueryPaymentImpl;
import kd.ebg.aqap.banks.wzb.opa.util.GetStore;
import kd.ebg.aqap.banks.wzb.opa.util.MsgParser;
import kd.ebg.aqap.banks.wzb.opa.util.PackerUtil;
import kd.ebg.aqap.banks.wzb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = PackerUtil.getBody();
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        body.put("transDate", (Object)date);
        body.put("orderNo", (Object)info.getBankBatchSeqID());
        body.put("payAcctName", (Object)info.getAccName());
        body.put("payAcctNo", (Object)info.getAccNo());
        body.put("batchNo", (Object)info.getBankBatchSeqID());
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (PaymentInfo paymentInfo : paymentInfos) {
            totalAmount = totalAmount.add(paymentInfo.getAmount());
        }
        body.put("sumAmt", (Object)totalAmount.toString());
        body.put("totalCnt", (Object)(paymentInfos.size() + ""));
        body.put("dcFlag", (Object)"2");
        JSONArray array = new JSONArray();
        body.put("transList", (Object)array);
        for (PaymentInfo paymentInfo : paymentInfos) {
            JSONObject each = new JSONObject();
            array.add((Object)each);
            each.put("rcvAcctNo", (Object)paymentInfo.getIncomeAccNo());
            each.put("rcvAcctSeqno", (Object)paymentInfo.getBankSerialNo());
            each.put("rcvAcctName", (Object)paymentInfo.getIncomeAccName());
            each.put("inbankname", (Object)info.getIncomeBankName());
            each.put("inbankno", (Object)info.getIncomeCnaps());
            each.put("transAmt", (Object)paymentInfo.getAmount().toString());
            each.put("busCode", (Object)"8");
            each.put("remark", (Object)paymentInfo.getExplanation());
        }
        return JSONObject.toJSONString((Object)body);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String result = MsgParser.getReceMsg(responseStr);
        JSONObject response = JSONObject.parseObject((String)result);
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d1\u9001 \u94f6\u884c\u5904\u7406\u72b6\u6001\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (String)"", (String)"");
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "batchtrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u652f\u4ed8", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType()) && paymentInfo.getTotalCount() > 1;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String url = GetStore.getBaseUrl() + "/V1/P01508/S01/batchtrans";
        EBContext.getContext().setProcessFlag(PROCESS_PACK);
        try {
            String rqstStr = this.pack(request);
            String rspStr = "";
            rspStr = PostUtil.sendMsgForPay(rqstStr, url);
            if (rspStr == null) {
                return null;
            }
            try {
                return this.parse(request, rspStr);
            }
            catch (Exception e) {
                EBContext.getContext().setThrowableAfterSend((Throwable)e);
                return null;
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }
}

