/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.services.payment.batch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wzb.opa.util.GetStore;
import kd.ebg.aqap.banks.wzb.opa.util.MsgParser;
import kd.ebg.aqap.banks.wzb.opa.util.PackerUtil;
import kd.ebg.aqap.banks.wzb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public int getBatchSize() {
        return 100;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = PackerUtil.getBody();
        body.put("payAcctNo", (Object)info.getAccNo());
        body.put("batchNo", (Object)info.getBankBatchSeqID());
        return JSONObject.toJSONString((Object)body);
    }

    public static PaymentInfo selectPaymentInfo(List<PaymentInfo> infos, String bankDetailSeqID) {
        PaymentInfo info;
        Iterator<PaymentInfo> var2 = infos.iterator();
        do {
            if (var2.hasNext()) continue;
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u6307\u4ee4\u6d41\u6c34\u53f7:%s\u3002", (String)"EBGBusinessUtils_5", (String)"ebg-aqap-business", (Object[])new Object[0]), bankDetailSeqID);
            logger.info(errorMsg);
            return null;
        } while (!(info = var2.next()).getBankSerialNo().equalsIgnoreCase(bankDetailSeqID));
        return info;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if ("ebgprocess".equals(responseStr)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d1\u9001 \u94f6\u884c\u5904\u7406\u72b6\u6001\u3002", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        String result = MsgParser.getReceMsg(responseStr);
        JSONObject response = JSONObject.parseObject((String)result);
        JSONObject data = response.getJSONObject("data");
        JSONArray transList = data.getJSONArray("transList");
        if (transList == null || transList.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)"");
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        for (int i = 0; i < transList.size(); ++i) {
            JSONObject each = transList.getJSONObject(i);
            String dealStatus = each.getString("dealStatus");
            String errMsg = each.getString("errMsg");
            String rcvAcctSeqno = each.getString("rcvAcctSeqno");
            PaymentInfo payment = QueryPaymentImpl.selectPaymentInfo(paymentInfos, rcvAcctSeqno);
            if (payment == null) continue;
            if ("0".equals(dealStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d1\u9001 \u94f6\u884c\u5904\u7406\u72b6\u6001\u3002", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (String)"", (String)"");
                continue;
            }
            if ("1".equals(dealStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.SUCCESS, (String)"", (String)dealStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]));
                continue;
            }
            if ("2".equals(dealStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.FAIL, (String)"", (String)dealStatus, (String)errMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payment, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)dealStatus, (String)errMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "selbatchtrans";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u72b6\u6001\u67e5\u8be2", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String url = GetStore.getBaseUrl() + "/V1/P01509/S01/selbatchtrans";
        try {
            String rqstStr = this.pack(request);
            String rspStr = PostUtil.sendMsg(rqstStr, url);
            return this.parse(request, rspStr);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }
}

