/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.util;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wzb.opa.util.GetStore;
import kd.ebg.aqap.banks.wzb.opa.util.HttpUtil;
import kd.ebg.aqap.banks.wzb.opa.util.SMHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class PostUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PostUtil.class);

    public static String getEncryBody(String params) {
        try {
            return SMHelper.encrypt(params, GetStore.getSM(), GetStore.getVI());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53d1\u9001\u6570\u636e\u52a0\u5bc6\u5f02\u5e38\u3002", (String)"PostUtil_0", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static String getSign(String encryBody) {
        String appId = RequestContextUtils.getBankParameterValue((String)"appId");
        LinkedHashMap<String, String> body = new LinkedHashMap<String, String>();
        body.put("x-aob-appID", appId);
        body.put("x-aob-bankID", "WZB");
        body.put("bizContent", encryBody);
        try {
            return SMHelper.sign(JSONObject.toJSONString(body), GetStore.getPRI());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53d1\u9001\u6570\u636e\u7b7e\u540d\u5f02\u5e38\u3002", (String)"PostUtil_1", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static String sendMsg(String params, String url) {
        logger.info("SEND MSG :" + params);
        logger.info("url:" + url);
        String encryBody = PostUtil.getEncryBody(params);
        String sign = PostUtil.getSign(encryBody);
        JSONObject encry = new JSONObject();
        encry.put("bizContent", (Object)encryBody);
        return HttpUtil.execPostOrPut(sign, JSONObject.toJSONString((Object)encry), url);
    }

    public static String sendMsgForPay(String params, String url) {
        logger.info("SEND MSG :" + params);
        logger.info("url:" + url);
        String encryBody = PostUtil.getEncryBody(params);
        String sign = PostUtil.getSign(encryBody);
        JSONObject encry = new JSONObject();
        encry.put("bizContent", (Object)encryBody);
        return HttpUtil.execPostOrPutForPay(sign, JSONObject.toJSONString((Object)encry), url);
    }

    private static String getUrl(String url) {
        return GetStore.getBaseUrl() + url;
    }
}

