/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.util.sm2;

import java.io.IOException;
import java.math.BigInteger;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2Const;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2KeyPair;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.SM2Util;
import kd.ebg.aqap.banks.wzb.opa.util.sm2.Signature;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.math.ec.ECPoint;

public class SM2
implements SM2Const {
    private final DSAEncoding encoding = StandardDSAEncoding.INSTANCE;

    public byte[] signWithEncode(String data, SM2KeyPair keyPair) throws IOException {
        return this.signWithEncode(data.getBytes(), "1234567812345678".getBytes(), keyPair);
    }

    public byte[] signWithEncode(byte[] data, byte[] ida, SM2KeyPair keyPair) throws IOException {
        Signature signature = this.sign(data, ida, keyPair);
        return this.encoding.encode(N, signature.r, signature.s);
    }

    public Signature sign(byte[] data, byte[] ida, SM2KeyPair keyPair) {
        BigInteger k;
        BigInteger r;
        byte[] ZA = SM2Util.ZA(ida, keyPair.getPublicKey());
        byte[] M_ = SM2Util.join(ZA, data);
        BigInteger e = new BigInteger(1, SM2Util.sm3hash(new byte[][]{M_}));
        do {
            k = SM2Util.random(N);
            ECPoint p1 = G.multiply(k).normalize();
            BigInteger x1 = p1.getXCoord().toBigInteger();
            r = e.add(x1);
        } while ((r = r.mod(N)).equals(BigInteger.ZERO) || r.add(k).equals(N));
        BigInteger s = keyPair.getPrivateKey().add(BigInteger.ONE).modInverse(N).multiply(k.subtract(r.multiply(keyPair.getPrivateKey())).mod(N)).mod(N);
        return new Signature(r, s);
    }
}

