/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ZJRC_DC_Parser {
    public static BankResponse parserCommonInfo(Element root) {
        BankResponse bankResponse = new BankResponse();
        Element resHead = JDomUtils.getChildElement((Element)root, (String)"resHead");
        String retCode = JDomUtils.getChildText((Element)resHead, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)resHead, (String)"errMsg");
        bankResponse.setResponseCode(retCode);
        bankResponse.setResponseMessage(errMsg);
        return bankResponse;
    }

    public static EBBankPayResponse parserPayResult(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"ZJRC_DC_Parser_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ZJRC_DC_Parser_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
        String comFlowNo = JDomUtils.getChildText((Element)resBody, (String)"commFlowNo");
        if (null == comFlowNo || "".equals(comFlowNo)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"ZJRC_DC_Parser_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6307\u4ee4\u5e8f\u53f7\u672a\u77e5\uff0c\u5c06\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ed3\u679c\u3002", (String)"ZJRC_DC_Parser_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        } else {
            PaymentInfoSysFiled.set((List)paymentInfos, (String)"comFlowNo", (String)comFlowNo);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static void matchPaymentInfo(Map<String, String> infoMap, List<PaymentInfo> paymentInfos) {
        for (PaymentInfo paymentInfo : paymentInfos) {
            String accNo = paymentInfo.getAccNo();
            String incomeAccNo = paymentInfo.getIncomeAccNo();
            String amount = paymentInfo.getAmount().toString();
            String key = accNo + incomeAccNo + amount;
            if (infoMap.containsKey(key)) {
                PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"comFlowNo", (String)infoMap.get(key));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"ZJRC_DC_Parser_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6307\u4ee4\u5e8f\u53f7\u4e0d\u5339\u914d\uff0c\u5c06\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ed3\u679c\u3002", (String)"ZJRC_DC_Parser_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        }
    }

    public static EBBankPayResponse parseBatchPayResult(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"ZJRC_DC_Parser_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ZJRC_DC_Parser_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
        String batchNo = JDomUtils.getChildText((Element)resBody, (String)"batchNo");
        if (null == batchNo) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"ZJRC_DC_Parser_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u6279\u6b21\u6d41\u6c34\u53f7\u3002", (String)"ZJRC_DC_Parser_4", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        } else {
            for (PaymentInfo paymentInfo : paymentInfos) {
                PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)"batchNo", (String)batchNo);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static String getResponseMsg(String code) {
        String tempStr = null;
        if (code.equals("-1")) {
            tempStr = ResManager.loadKDString((String)"\u672a\u77e5\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u3002", (String)"ZJRC_DC_Parser_5", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("0")) {
            tempStr = ResManager.loadKDString((String)"\u7b49\u5f85\u590d\u6838", (String)"ZJRC_DC_Parser_6", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("1")) {
            tempStr = ResManager.loadKDString((String)"\u590d\u6838\u88ab\u62d2\u7edd", (String)"ZJRC_DC_Parser_7", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("10")) {
            tempStr = ResManager.loadKDString((String)"\u7b49\u5f85\u6388\u6743", (String)"ZJRC_DC_Parser_8", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("11")) {
            tempStr = ResManager.loadKDString((String)"\u6388\u6743\u88ab\u62d2\u7edd", (String)"ZJRC_DC_Parser_9", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("20")) {
            tempStr = ResManager.loadKDString((String)"\u7b49\u5f85\u7cfb\u7edf\u5904\u7406", (String)"ZJRC_DC_Parser_10", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("21")) {
            tempStr = ResManager.loadKDString((String)"\u7b49\u5f85\u624b\u5de5\u53d1\u9001", (String)"ZJRC_DC_Parser_11", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("48")) {
            tempStr = ResManager.loadKDString((String)"\u7b49\u5f85\u52a0\u5165\u5904\u7406\u961f\u5217", (String)"ZJRC_DC_Parser_12", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("49")) {
            tempStr = ResManager.loadKDString((String)"\u7b49\u5f85\u53d1\u9001\u4e3b\u673a", (String)"ZJRC_DC_Parser_13", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("50")) {
            tempStr = ResManager.loadKDString((String)"\u4e3b\u673a\u5904\u7406\u4e2d", (String)"ZJRC_DC_Parser_14", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("90")) {
            tempStr = ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ZJRC_DC_Parser_15", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("91")) {
            tempStr = ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ZJRC_DC_Parser_16", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("92")) {
            tempStr = ResManager.loadKDString((String)"\u4ea4\u6613\u4f5c\u5e9f", (String)"ZJRC_DC_Parser_17", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("93")) {
            tempStr = ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u53d6\u6d88", (String)"ZJRC_DC_Parser_18", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("94")) {
            tempStr = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"ZJRC_DC_Parser_19", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("95")) {
            tempStr = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"ZJRC_DC_Parser_20", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("96")) {
            tempStr = ResManager.loadKDString((String)"\u5f85\u53d1\u9001\u5df2\u64a4\u9500", (String)"ZJRC_DC_Parser_21", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("97")) {
            tempStr = ResManager.loadKDString((String)"\u5f85\u590d\u6838\u5df2\u64a4\u9500", (String)"ZJRC_DC_Parser_22", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("98")) {
            tempStr = ResManager.loadKDString((String)"\u5f85\u6388\u6743\u5df2\u64a4\u9500", (String)"ZJRC_DC_Parser_23", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        } else if (code.equals("99")) {
            tempStr = ResManager.loadKDString((String)"\u4ea4\u6613\u53ef\u7591", (String)"ZJRC_DC_Parser_24", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
        }
        return tempStr;
    }

    public static int getResponseFlag(String code) {
        int flag = 0;
        if (code.equals("11") || code.equals("91")) {
            flag = -1;
        } else if (code.equals("92") || code.equals("93")) {
            flag = -1;
        } else if (code.equals("94") || code.equals("95")) {
            flag = -1;
        } else if (code.equals("96") || code.equals("97") || code.equals("98")) {
            flag = -1;
        } else if (code.equals("90")) {
            flag = 1;
        }
        return flag;
    }

    public static boolean isSuccessed(String code) {
        if (ZJRC_DC_Parser.getResponseFlag(code) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean isFailed(String code) {
        if (ZJRC_DC_Parser.getResponseFlag(code) == -1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void setEBGBussinessState(Map<String, BankResponse> infoMap, List<PaymentInfo> paymentInfos) {
        ZJRC_DC_Parser.matchSetPaymentState(infoMap, paymentInfos, true);
    }

    public static void matchSetPaymentState(Map<String, BankResponse> infoMap, List<PaymentInfo> paymentInfos, boolean detailSeq) {
        for (PaymentInfo paymentInfo : paymentInfos) {
            String key = paymentInfo.getBankDetailSeqId();
            if (!detailSeq) {
                key = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"comFlowNo");
            }
            if (infoMap.containsKey(key)) {
                String state = infoMap.get(key).getResponseCode();
                String errorString = infoMap.get(key).getResponseMessage();
                if (ZJRC_DC_Parser.isSuccessed(state)) {
                    EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)state, (String)ZJRC_DC_Parser.getResponseMsg(state), (String)errorString);
                    continue;
                }
                if (ZJRC_DC_Parser.isFailed(state)) {
                    EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)state, (String)ZJRC_DC_Parser.getResponseMsg(state), (String)errorString);
                    continue;
                }
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)state, (String)ZJRC_DC_Parser.getResponseMsg(state), (String)errorString);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5e8f\u53f7\u4e0d\u5339\u914d\uff0c\u72b6\u6001\u672a\u77e5\u3002", (String)"ZJRC_DC_Parser_25", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5e8f\u53f7\u4e0d\u5339\u914d\uff0c\u72b6\u6001\u672a\u77e5\u3002", (String)"ZJRC_DC_Parser_26", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        }
    }
}

