/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.allocation;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ZJRC_DC_Packer.getCommonHeader("100006", ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"payAccount", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)reqBody, (String)"payAccountName", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)reqBody, (String)"currencyType", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)reqBody, (String)"payAmount", (String)((PaymentInfo)paymentInfos.get(0)).getAmount().toString());
        JDomUtils.addChild((Element)reqBody, (String)"payUse", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)reqBody, (String)"payRem", (String)((PaymentInfo)paymentInfos.get(0)).getUseCn());
        JDomUtils.addChild((Element)reqBody, (String)"recAccount", (String)((PaymentInfo)paymentInfos.get(0)).getIncomeAccNo());
        JDomUtils.addChild((Element)reqBody, (String)"recAccountName", (String)((PaymentInfo)paymentInfos.get(0)).getIncomeAccName());
        JDomUtils.addChild((Element)reqBody, (String)"transferTowardType", (String)(((PaymentInfo)paymentInfos.get(0)).is2SameCity() ? "0" : "1"));
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
            String comFlowNo = JDomUtils.getChildText((Element)resBody, (String)"commFlowNo");
            if (null == comFlowNo) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6307\u4ee4\u5e8f\u53f7\u672a\u77e5\uff0c\u5c06\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ed3\u679c\u3002", (String)"AllocationPayImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
            } else {
                PaymentInfoSysFiled.set((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (String)"comFlowNo", (String)comFlowNo);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100006";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

