/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hfb.dc.services.payment.otherbank;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hfb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hfb.dc.util.HFB_Packer;
import kd.ebg.aqap.banks.hfb.dc.util.SignByNc;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        String remark;
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u7684\u884c\u5916\u8f6c\u8d26\u4ea4\u6613\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u8f6c\u8d26\u3002", (String)"PayPacker_2", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Element root = HFB_Packer.buildHead(paymentInfo.getBankDetailSeqID());
        Element opReq = root.getChild("opReq");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"reqParam");
        String reqTime = DateUtil.formatDateTime((Date)new Date());
        String custno = RequestContextUtils.getBankParameterValue((String)"CORP_NO");
        String amount = paymentInfo.getAmount().setScale(2, 1).toString();
        String usg = remark = paymentInfo.getExplanation();
        String exp = remark;
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            exp = BizNoUtil.cont((String)paymentInfo.getBankDetailSeqID(), (String)remark);
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        if (!StringUtils.isEmpty((String)usg) && usg.length() > 200) {
            usg = usg.substring(200);
        }
        if (!StringUtils.isEmpty((String)exp) && exp.length() > 100) {
            exp = exp.substring(100);
        }
        String signature = "#$serialNo=" + paymentInfo.getBankDetailSeqID() + "#$cstNo=" + custno + "#$reqTime=" + reqTime + "#$erpPid=#$ACNO=" + paymentInfo.getAccNo() + "#$OPAC=" + paymentInfo.getIncomeAccNo() + "#$OPNM=" + paymentInfo.getIncomeAccName() + "#$EXNM=" + paymentInfo.getIncomeBankName() + "#$PBNO=" + paymentInfo.getIncomeCnaps() + "#$TRAM=" + amount + "#$USAG=" + usg + "#$IFFT=0#$REMK=" + exp;
        SignByNc signStr = new SignByNc();
        Element sign = JDomUtils.addChild((Element)root, (String)"sign");
        try {
            JDomUtils.addChild((Element)sign, (String)"signedData", (String)signStr.sign(signature));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff1a%s\u3002", (String)"PayPacker_4", (String)"ebg-aqap-banks-hfb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"OPAC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"OPNM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"EXNM", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)reqParam, (String)"PBNO", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)reqParam, (String)"TRAM", (String)amount);
        String c = BankBusinessConfig.popResult();
        JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)("3".equalsIgnoreCase(c) ? "" : usg));
        JDomUtils.addChild((Element)reqParam, (String)"REMK", (String)("2".equalsIgnoreCase(c) ? "" : exp));
        JDomUtils.addChild((Element)reqParam, (String)"IFFT", (String)"0");
        JDomUtils.addChild((Element)reqParam, (String)"ISNEEDDAUTH", (String)BankBusinessConfig.getPayMethod());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
    }
}

