/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srcb.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.srcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.srcb.dc.services.Packer;
import kd.ebg.aqap.banks.srcb.dc.services.Parser;
import kd.ebg.aqap.banks.srcb.dc.services.login.LoginAccess;
import kd.ebg.aqap.banks.srcb.dc.services.login.LoginAccessManager;
import kd.ebg.aqap.banks.srcb.dc.services.utils.DecryUtil;
import kd.ebg.aqap.banks.srcb.dc.services.utils.EncryUtil;
import kd.ebg.aqap.banks.srcb.dc.services.utils.SmUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        LoginAccess loginAccess = LoginAccessManager.searchLock();
        Element root = Packer.packHeader(this.getBizCode(), loginAccess.getToken());
        Element envelope = root.getChild("Envelope");
        Element body = JDomUtils.addChild((Element)envelope, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        String accNoType = BankBusinessConfig.getAccNoType((String)bankBalanceRequest.getAcnt().getAccNo());
        boolean isFixedAccNo = false;
        if ("fixed".equalsIgnoreCase(accNoType)) {
            isFixedAccNo = true;
        }
        JDomUtils.addChild((Element)body, (String)"AcctType", (String)(isFixedAccNo ? "30" : "20"));
        JDomUtils.addChild((Element)body, (String)"Currency", (String)bankBalanceRequest.getBankCurrency());
        String request = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        String sign = SmUtil.sign(request);
        this.logger.info("\u52a0\u5bc6\u524d\u62a5\u6587:{}", (Object)sign);
        String encry = EncryUtil.encry(sign);
        return RequestContextUtils.getBankParameterValue((String)"BankCertId") + encry;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String response) {
        boolean unitTest = EBContext.getContext().isUnitTest();
        String decry = "";
        if (unitTest) {
            decry = EBContext.getContext().getUnitTestData();
        } else {
            decry = DecryUtil.decry(response);
            boolean verify = SmUtil.verify(decry);
            if (!verify) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6df1\u5733\u519c\u5546\u884c\u67e5\u8be2\u4f59\u989d\u54cd\u5e94\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]));
            }
        }
        String realResponseMsg = Parser.getRealResponseMsg(decry);
        Element root = JDomUtils.string2Root((String)realResponseMsg, (String)RequestContextUtils.getCharset());
        Element envelope = root.getChild("Envelope");
        Element header = envelope.getChild("Header");
        Element body = envelope.getChild("Body");
        String resultCode = header.getChildTextTrim("ResultCode");
        String resultMessage = header.getChildTextTrim("ResultMessage");
        if (!"000000".equalsIgnoreCase(resultCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]), resultCode, resultMessage));
        }
        String acctNo = body.getChildText("AcctNo");
        String currency = body.getChildText("Currency");
        String ledgerBalance = body.getChildText("LedgerBalance");
        String usableBalance = body.getChildText("UsableBalance");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo info = new BalanceInfo();
        balances.add(info);
        BankAcnt bankAcnt = new BankAcnt();
        info.setBankAcnt(bankAcnt);
        bankAcnt.setAccNo(acctNo);
        info.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)usableBalance));
        info.setCurrentBalance(ParserUtils.convertCentStr2Yuan((String)ledgerBalance));
        BalanceUtils.CurrentBalanceVerification verification = BalanceUtils.currentBalanceVerification;
        if (!verification.apply(ledgerBalance)) {
            info.setError(verification.message());
        }
        info.setBankCurrency(currency);
        info.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "21001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-srcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
    }
}

