/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EActTrsQry");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        Element root = Packer.buildHead("B2EActTrsQry", null);
        Element map = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List").getChild("Map");
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)map, (String)"Currency", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String s) {
        ArrayList detailList = new ArrayList(1);
        BankAcnt acnt = request.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = Parser.parser(root);
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element body = root.getChild("Body");
            Element list = body.getChild("List");
            List records = list.getChildren("Map");
            for (int i = 0; i < records.size(); ++i) {
                Element record = (Element)records.get(i);
                if (!acnt.getAccNo().equals(record.getChildTextTrim("AcNo"))) continue;
                if (!"000000".equals(record.getChildTextTrim("ReturnCode"))) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
                }
                this.parserDetail(detailList, record, acnt, request);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        return new EBBankDetailResponse(detailList);
    }

    public void parserDetail(List detailList, Element record, BankAcnt acnt, BankDetailRequest request) {
        Element list = record.getChild("List");
        List maps = list.getChildren("Map");
        String currency = "";
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            DetailInfo detail = new DetailInfo();
            currency = map.getChildTextTrim("Currency");
            if (StringUtils.isEmpty((String)currency)) {
                currency = request.getBankCurrency();
            }
            detail.setCurrency(currency);
            detail.setOppAccNo(map.getChildTextTrim("PartnerAcct"));
            detail.setOppAccName(map.getChildTextTrim("PartnerAcName"));
            detail.setAccName(acnt.getAccName());
            detail.setAccNo(acnt.getAccNo());
            String transferDate = map.getChildTextTrim("TransDate");
            String transferTime = map.getChildTextTrim("TransTime");
            detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            detail.setTransTime(LocalDateTime.parse(transferDate + " " + transferTime.substring(0, 6), DateTimeFormatter.ofPattern("yyyy-MM-dd HHmmss")));
            String Amount = map.getChildTextTrim("Amount");
            if (StringUtils.isEmpty((String)Amount)) {
                this.logger.error("\u4ea4\u6613\u660e\u7ec6\u89e3\u6790\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u91d1\u989dAmount\u4e3a\u7a7a");
                continue;
            }
            BigDecimal amount = new BigDecimal(Amount);
            String CDFlag = map.getChildTextTrim("DCFlag");
            if (CDFlag.equalsIgnoreCase("D")) {
                detail.setDebitAmount(amount);
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else if (CDFlag.equalsIgnoreCase("C")) {
                detail.setDebitAmount(new BigDecimal("0.00"));
                detail.setCreditAmount(amount);
            } else {
                this.logger.error("\u4ea4\u6613\u660e\u7ec6\u89e3\u6790\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u501f\u8d37\u6807\u8bc6\u4e0d\u5408\u6cd5DCFlag={}", new Object[]{CDFlag});
                continue;
            }
            detail.setExplanation(map.getChildTextTrim("Remark"));
            String Balance = map.getChildTextTrim("Balance");
            if (StringUtils.isNotEmpty((String)Balance)) {
                detail.setBalance(new BigDecimal(Balance));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(map.getChildTextTrim("TrsJnlNo"));
            String rNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonStr);
            if (countMap.containsKey(rNo)) {
                int count = (Integer)countMap.get(rNo) + 1;
                countMap.put(rNo, count);
                rNo = rNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(rNo, 0);
            }
            detail.setReceiptNo(rNo);
            detailList.add(detail);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"B2EActTrsQry,\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_1", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]);
    }
}

