/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsb.dc.services.payment;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Packer;
import kd.ebg.aqap.banks.gsb.dc.services.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QryPaymentImpl.class);

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "B2EPaymentStatQry");
    }

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = Packer.buildHead("B2EPaymentStatQry", Sequence.gen18Sequence());
        Element Map2 = JDomUtils.getChildElement((Element)root, (String)"Body").getChild("List").getChild("Map");
        JDomUtils.addChild((Element)Map2, (String)"OldJnlNo", (String)paymentInfo.getBankBatchSeqId());
        String testSynDate = RequestContextUtils.getBankParameterValue((String)"synDate");
        logger.info("\u83b7\u53d6\u524d\u7f6e\u673a\u914d\u7f6e\u4e2d\u7684\u65e5\u671f\uff1a" + testSynDate);
        if (!StringUtils.isEmpty((String)testSynDate)) {
            logger.info("\u539f\u4ea4\u6613\u65e5\u671f\u4f20\u524d\u7f6e\u673a\u914d\u7f6e\u4e2d\u7684\u65e5\u671f\uff1a" + testSynDate);
            JDomUtils.addChild((Element)Map2, (String)"OldTrsDate", (String)testSynDate);
        } else {
            logger.info("\u539f\u4ea4\u6613\u65e5\u671f\uff1a" + PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"trsDate"));
            JDomUtils.addChild((Element)Map2, (String)"OldTrsDate", (String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"trsDate"));
        }
        JDomUtils.addChild((Element)Map2, (String)"PayAcnt", (String)"");
        JDomUtils.addChild((Element)Map2, (String)"RcvAcnt", (String)"");
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)"");
        JDomUtils.addChild((Element)Map2, (String)"CifNo", (String)"");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)"");
        JDomUtils.addChild((Element)Map2, (String)"Priority", (String)"");
        JDomUtils.addChild((Element)Map2, (String)"Bak1", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element mapElement = root.getChild("Body").getChild("List").getChild("Map");
        String returnCode = mapElement.getChildTextTrim("ReturnCode");
        String returnMsg = mapElement.getChildTextTrim("ReturnMsg");
        if (StringUtils.isNotEmpty((String)returnCode) && !"000000".equals(returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        String tranStat = mapElement.getChildTextTrim("TranStat");
        HashMap<String, String> tranStatMap = new HashMap<String, String>(7);
        tranStatMap.put("0", ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryPaymentImpl_1", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        tranStatMap.put("1", ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QryPaymentImpl_2", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        tranStatMap.put("A", ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406", (String)"QryPaymentImpl_3", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        tranStatMap.put("4", ResManager.loadKDString((String)"\u94f6\u884c\u62d2\u7edd", (String)"QryPaymentImpl_4", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        tranStatMap.put("11", ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QryPaymentImpl_5", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        tranStatMap.put("2", ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7", (String)"QryPaymentImpl_6", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        tranStatMap.put("3", ResManager.loadKDString((String)"\u5ba1\u6838\u62d2\u7edd", (String)"QryPaymentImpl_7", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]));
        if ("0".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)tranStat, (String)((String)tranStatMap.get(tranStat)));
        } else if ("1".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)tranStat, (String)((String)tranStatMap.get(tranStat)));
        } else if ("11".equals(tranStat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)tranStat, (String)((String)tranStatMap.get(tranStat)));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)tranStat, (String)((String)tranStatMap.get(tranStat)));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EPaymentStatQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u540c\u884c\u8de8\u884c\u4ed8\u6b3e", (String)"QryPaymentImpl_8", (String)"ebg-aqap-banks-gsb-dc", (Object[])new Object[0]);
    }
}

