/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tccb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tccb.dc.utils.TCommon;
import kd.ebg.aqap.banks.tccb.dc.utils.TPacker;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String acntNo = acnt.getAccNo();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "B2eQueryAccountDetail";
        String userID = RequestContextUtils.getBankParameterValue((String)"userID");
        String userPassword = RequestContextUtils.getBankParameterValue((String)"userPassword");
        String operatorID = RequestContextUtils.getBankParameterValue((String)"operatorID");
        LocalDateTime now = LocalDateTime.now();
        String d = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        Element transaction = TPacker.createCommonHead(tr_code, userID, userPassword, operatorID, req_no, "1", d);
        Element RequestBody = JDomUtils.addChild((Element)transaction, (String)"RequestBody");
        Element RequestRecord = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        String beginDateStr = request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDateStr = request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String checkType = "1";
        if (DateUtil.isSameDay((LocalDate)LocalDate.now(), (LocalDate)startDate) && DateUtil.isSameDay((LocalDate)startDate, (LocalDate)endDate)) {
            checkType = "2";
        }
        JDomUtils.addChild((Element)RequestRecord, (String)"transID", (String)req_no);
        JDomUtils.addChild((Element)RequestRecord, (String)"CheckType", (String)checkType);
        JDomUtils.addChild((Element)RequestRecord, (String)"AcctNo", (String)acntNo);
        JDomUtils.addChild((Element)RequestRecord, (String)"BeginDate", (String)beginDateStr);
        JDomUtils.addChild((Element)RequestRecord, (String)"EndDate", (String)endDateStr);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2String((Element)transaction, (String)encoding);
        return xmlMsg;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element transaction = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element RespondHeader = transaction.getChild("RespondHeader");
        String respondTime = RespondHeader.getChildTextTrim("respondTime");
        Element RespondBody = transaction.getChild("RespondBody");
        Element RespondRecord = RespondBody.getChild("RespondRecord");
        String returnCode = RespondRecord.getChildTextTrim("returnCode");
        String returnInfo = RespondRecord.getChildTextTrim("returnInfo");
        if ("AC49".equals(returnCode)) {
            return new EBBankDetailResponse(details);
        }
        if (!"0000".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), returnCode, returnInfo));
        }
        Element itemsSet = RespondRecord.getChild("itemsSet");
        if (itemsSet == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1aitemsSet\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]));
        }
        List item = itemsSet.getChildren("item");
        if (item == null || item.size() == 0) {
            return new EBBankDetailResponse(details);
        }
        for (int i = 0; i < item.size(); ++i) {
            Element row = (Element)item.get(i);
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setCurrency(request.getBankCurrency());
            String TranFlag = row.getChildTextTrim("TranFlag");
            String amount = row.getChildTextTrim("TxAmount");
            if (StringUtils.isEmpty((String)amount)) {
                this.log.error("\u4ea4\u6613\u91d1\u989dTxAmount\u8fd4\u56de\u4e3a\u7a7a");
                continue;
            }
            if ("D".equalsIgnoreCase(TranFlag)) {
                detailInfo.setCreditAmount(new BigDecimal("0.00"));
                detailInfo.setDebitAmount(new BigDecimal(amount));
            } else if ("C".equalsIgnoreCase(TranFlag)) {
                detailInfo.setCreditAmount(new BigDecimal(amount));
                detailInfo.setDebitAmount(new BigDecimal("0.00"));
            } else {
                this.log.error(String.format(ResManager.loadKDString((String)"\u51fa\u73b0\u4e86\u672a\u80fd\u8bc6\u522b\u7684\u501f\u8d37\u6807\u5fd7%1$s\u3002", (String)"DetailImpl_6", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), TranFlag));
                continue;
            }
            String balance = row.getChildTextTrim("AcctBalance");
            if (StringUtils.isNotEmpty((String)balance)) {
                detailInfo.setBalance(new BigDecimal(balance));
            }
            detailInfo.setExplanation(row.getChildTextTrim("Note"));
            LocalDate transDate = LocalDate.parse(row.getChildTextTrim("TransDate"), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            detailInfo.setTransDate(transDate);
            detailInfo.setTransTime(transDate.atTime(LocalTime.MIDNIGHT));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(row.getChildTextTrim("SeqNo"));
            details.add(detailInfo);
        }
        this.log.info("---\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f");
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2eQueryAccountDetail";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6", (String)"DetailImpl_4", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = TCommon.getEncoding();
        factory.setUri(TPacker.getHttpUrl("detail"));
        factory.setHttpHeader("content-type", "text/xml; charset=" + encoding);
    }
}

