/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zrc.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zrc.dc.ZrcDcBankBusinessConfig;
import kd.ebg.aqap.banks.zrc.dc.services.detail.DetailHelper;
import kd.ebg.aqap.banks.zrc.dc.util.Request;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailImpl.class);
    private static int pageSize = 20;

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/eweb-query.BSHisDetailOp.do?";
        s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("user_password") + "&SIGDATA=1";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        EBBankDetailResponse detailResponse = super.doBiz(request);
        detailInfos.addAll(detailResponse.getDetails());
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = new Element("ROOT");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)root, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"opName", (String)"BSHisDetailOp");
        Element body = new Element("ReqParam");
        String Areacode = bankDetailRequest.getAcnt().getAreaCode();
        JDomUtils.addChild((Element)body, (String)"Area_code", (String)Areacode);
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        JDomUtils.addChild((Element)body, (String)"Account_num", (String)accNo);
        String cur = bankDetailRequest.getBankCurrency();
        JDomUtils.addChild((Element)body, (String)"Account_cur", (String)cur);
        String startDate = bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"Begin_date", (String)startDate);
        JDomUtils.addChild((Element)body, (String)"End_date", (String)endDate);
        JDomUtils.addChild((Element)body, (String)"userID", (String)RequestContextUtils.getBankParameterValue((String)"userid"));
        JDomUtils.addChild((Element)body, (String)"PackageID", (String)Sequence.gen14Sequence());
        JDomUtils.addChild((Element)body, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)body, (String)"ReqReserved2", (String)"");
        JDomUtils.addChild((Element)opReq, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return RspMsg;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        return new EBBankDetailResponse(this.parseDetail(bankDetailRequest, rspStr));
    }

    private List<DetailInfo> parseDetail(BankDetailRequest bankDetailRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getChildElement((Element)opRep, (String)"opResult");
        String retCode = JDomUtils.getChildText((Element)opResult, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opResult, (String)"errMsg");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>();
        if (retCode == null || !"0".equals(retCode)) {
            logger.info("\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff08" + retCode + "\uff09\uff1a" + errMsg);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff08%1$s\uff09\uff1a%2$s", (String)"HisDetailImpl_5", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), retCode, errMsg));
        }
        Element opResultSet = JDomUtils.getChildElement((Element)opRep, (String)"opResultSet");
        List list = opResultSet.getChildren("opResult");
        if (list != null && list.size() > 0) {
            logger.info("\u94f6\u884c\u8fd4\u56de\u8bb0\u5f55\u6761\u6570\uff1a" + list.size());
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
            for (int i = 0; i < list.size(); ++i) {
                DetailInfo detail = new DetailInfo();
                Element row = (Element)list.get(i);
                String Account_num = row.getChildTextTrim("Account_num");
                String transDate = row.getChildTextTrim("Trans_date");
                String Check_num = row.getChildTextTrim("Check_num");
                String Trans_abstr = row.getChildTextTrim("Trans_abstr");
                String Amount = Request.processBalance(row.getChildTextTrim("Amount"));
                String sign = row.getChildTextTrim("sign");
                String Balance = Request.processBalance(row.getChildTextTrim("Balance"));
                String Rec_Account_num = row.getChildTextTrim("Rec_Account_num");
                String Bank_name = row.getChildTextTrim("Bank_name");
                String Bank1_name = row.getChildTextTrim("Bank1_name");
                row.getChildTextTrim("Unit1_name");
                String Trans_type = row.getChildTextTrim("Trans_type");
                String Yt = row.getChildTextTrim("Yt");
                String Trans_time = row.getChildTextTrim("Trans_time");
                String oppName = row.getChildTextTrim("Unit1_name");
                try {
                    String newtime = Trans_time.replace("-", "");
                    String newtime1 = newtime.replace(":", "");
                    String newtime2 = newtime1.substring(0, 14);
                    LocalDateTime transDateTime = LocalDateTime.parse(newtime2, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    detail.setTransTime(transDateTime);
                }
                catch (Exception ex) {
                    logger.info("\u89e3\u6790\u94f6\u884c\u65e5\u671f\u5f02\u5e38\uff1a" + Trans_time);
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u65e5\u671f\u9519\u8bef%s", (String)"HisDetailImpl_6", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), Trans_time), (Throwable)ex);
                }
                try {
                    detail.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                }
                catch (Exception ex) {
                    logger.info("\u89e3\u6790\u4ea4\u6613\u65e5\u671f\u5f02\u5e38\uff1a" + transDate);
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4ea4\u6613\u65e5\u671f\u9519\u8bef%s", (String)"HisDetailImpl_7", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), transDate), (Throwable)ex);
                }
                detail.setBalance(new BigDecimal(Balance));
                detail.setAccNo(Account_num);
                detail.setOppAccNo(Rec_Account_num);
                detail.setOppAccName(StringUtils.isEmpty((String)oppName) ? "" : oppName);
                detail.setBankName(Bank_name);
                detail.setOppBankName(Bank1_name);
                detail.setBankDetailNo(Check_num);
                String currency = bankDetailRequest.getBankCurrency();
                detail.setCurrency(currency);
                detail.setTransType(Trans_type);
                detail.setExplanation(Yt);
                if ("1".equals(sign)) {
                    detail.setDebitAmount(new BigDecimal(Amount));
                    detail.setCreditAmount(new BigDecimal("0.00"));
                } else if ("2".equals(sign)) {
                    detail.setCreditAmount(new BigDecimal(Amount));
                    detail.setDebitAmount(new BigDecimal("0.00"));
                } else {
                    logger.info("\u65e0\u6cd5\u8bc6\u522b\u7684\u501f\u8d37\u6807\u5fd7" + sign);
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u501f\u8d37\u6807\u5fd7%s", (String)"HisDetailImpl_8", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), sign));
                }
                if (!StringUtils.isEmpty((String)Trans_abstr) && Trans_abstr.indexOf("KD_") != -1) {
                    String tmp = DetailHelper.parseKDDetailNo(Trans_abstr);
                    detail.setPayBankDetailSeqID(tmp);
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                if (ZrcDcBankBusinessConfig.isNewApi(bankDetailRequest.getAcnt().getBankLoginId(), RequestContext.get().getTenantId())) {
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                    String cdFlag = jsonObject.getString("ReqReserved3");
                    if (!StringUtils.isEmpty((String)Trans_abstr)) {
                        jsonObject.put("cdFlag", (Object)cdFlag);
                    } else {
                        jsonObject.put("cdFlag", (Object)"e");
                    }
                    jsonStr = jsonObject.toJSONString();
                }
                detail.setJsonMap(jsonStr);
                String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detail.setBankDetailNo(Check_num);
                detailInfos.add(detail);
            }
        }
        return detailInfos;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "BSHisDetailOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u8bf7\u6c42", (String)"HisDetailImpl_4", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]);
    }
}

