/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public boolean match(BankBalanceRequest request) {
        return true;
    }

    public String pack(BankBalanceRequest request) {
        Element bank_root = new Element("ap");
        Element head = GLBPacker.getHeadPackerData("200108", "0");
        Element body = this.getBalanceRequestBody(request);
        JDomUtils.addChild((Element)bank_root, (Element)head);
        JDomUtils.addChild((Element)bank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)bank_root, (String)encoding);
        return TCommon.createCommonMsg(rqstStr);
    }

    private Element getBalanceRequestBody(BankBalanceRequest request) throws EBServiceException {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getHeader().getBankCurrency());
        return body;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(responseStr), (String)encoding);
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        Element head = root.getChild("head");
        String retCode = head.getChildText("ret_code");
        String succFlag = head.getChildText("succ_flag");
        if ("0000".equalsIgnoreCase(retCode) && "0".equalsIgnoreCase(succFlag)) {
            Element body = root.getChild("body");
            if (!body.getChildText("acno").equalsIgnoreCase(request.getAcnt().getAccNo())) {
                String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u6c42\u67e5\u8be2\u7684\u8d26\u6237\u53f7\uff08%1$s\uff09\u548c\u8fd4\u56de\u7ed3\u679c\u7684\u8d26\u6237\u53f7\uff08%2$s\uff09\u4e0d\u4e00\u81f4\uff01", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), body.getChildText("acno"));
                throw EBExceiptionUtil.serviceException((String)resMsg);
            }
            String balance = body.getChildText("balance");
            balanceInfo.setCurrentBalance(BigDecimalHelper.str2BigDecimalForBalance((String)balance, (Boolean)false));
            String use_balance = body.getChildText("use_balance");
            if (StringUtils.isNotEmpty((String)use_balance)) {
                balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
            }
            balanceInfo.setBankCurrency(request.getHeader().getBankCurrency());
            BankAcnt bankAcnt2 = new BankAcnt();
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            String accNo = request.getAcnt().getAccNo();
            bankAcnt2.setAccNo(accNo);
            balanceInfo.setBankAcnt(bankAcnt2);
            balances.add(balanceInfo);
        } else {
            String ret_info = head.getChildText("ret_info");
            String ext_info = head.getChildText("ext_info");
            String string = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s,\u9644\u52a0\u5f02\u5e38\u4fe1\u606f:%3$s", (String)"TodayBalanceImpl_8", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), retCode, ret_info, ext_info);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "lei luo";
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }
}

