/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.batch;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.batch.CompanyBatchPayImpl;
import kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.batch.CompanyBatchSerialCodeQueryImpl;
import kd.ebg.aqap.banks.njb.dc.services.proxy.FileProxy;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyBatchPayQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyBatchPayQueryImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200202";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"CompanyBatchPayQueryImpl_0", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return info.getImplClassName().equals(CompanyBatchPayImpl.class.getName());
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfolist = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        paymentInfolist.toArray(paymentInfos);
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("200202", "0"));
        Element body = new Element("body");
        ZoneId zoneId = ZoneId.systemDefault();
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        ZonedDateTime zdt = paymentInfos[0].getRequestTime().atZone(zoneId);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String time = df.format(Date.from(zdt.toInstant()));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)time);
        String serialCode = new CompanyBatchSerialCodeQueryImpl().getSerialCode(bankPayRequest);
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serialCode);
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(requestMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfolist = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        paymentInfolist.toArray(paymentInfos);
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        Element body = bank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyBatchPayQueryImpl_1", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            String record_num = body.getChildTextTrim("record_num");
            String field_num = body.getChildTextTrim("field_num");
            int recordNum = -1;
            if (!StringUtils.isEmpty((String)record_num)) {
                recordNum = Integer.parseInt(record_num);
            }
            int fieldNum = -1;
            if (!StringUtils.isEmpty((String)field_num)) {
                fieldNum = Integer.parseInt(field_num);
            }
            String content = null;
            if (recordNum <= 0) {
                log.error("###\u672c\u6b21\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002");
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyBatchPayQueryImpl_2", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyBatchPayQueryImpl_2", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
            } else {
                if ("0".equals(head.getChildTextTrim("file_flag"))) {
                    String serial_record;
                    content = serial_record = body.getChildTextTrim("serial_record");
                } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
                    String file_name = body.getChildTextTrim("file_name");
                    content = new FileProxy().download(file_name);
                }
                String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
                CompanyBatchPayQueryImpl.parsepayInfo(bankPayRequest, rs);
            }
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    private static void parsepayInfo(BankPayRequest bankPayRequest, String[][] rs) throws EBServiceException {
        List<PaymentInfo> paymentInfos = CompanyBatchPayQueryImpl.preBatchSameItemCheck(bankPayRequest);
        for (int i = 0; i < rs.length; ++i) {
            String accnbr = rs[i][2];
            String trsamt = rs[i][5];
            String TransStatus = rs[i][16];
            String errorMsg = rs[i][17];
            if (StringUtils.isEmpty((String)trsamt)) {
                log.error("\u94f6\u884c\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u91d1\u989dtrsamt\u4e3a\u7a7a");
                continue;
            }
            BigDecimal amount = new BigDecimal(trsamt.trim());
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)accnbr, (BigDecimal)(amount = amount.setScale(2)));
            if (null == paymentInfo) continue;
            CompanyBatchPayQueryImpl.handlePayStatus(paymentInfo, TransStatus, errorMsg);
        }
        CompanyBatchPayQueryImpl.processingBankItemDataHandler(rs);
        PayStatusMatchUtil.backBatchSameItemHandler((List)bankPayRequest.getPaymentInfos(), (boolean)false, (boolean)false);
    }

    private static List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    private static void processingBankItemDataHandler(String[][] rs) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (int i = 0; i < rs.length; ++i) {
                    String rcvAcNo = rs[i][2];
                    String rcvAcName = rs[i][4];
                    String amt = rs[i][5];
                    String bankDataKey = CompanyBatchPayQueryImpl.getBankDataKey(rcvAcNo, rcvAcName, amt);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String TransStatus = rs[i][16];
                    String errorMsg = rs[i][17];
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    CompanyBatchPayQueryImpl.handlePayStatus(tempInfo, TransStatus, errorMsg);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private static PaymentInfo handlePayStatus(PaymentInfo tempInfo, String TransStatus, String errorMsg) {
        if ("9".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)TransStatus, (String)"");
        } else if ("6".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)TransStatus, (String)errorMsg);
        } else if ("7".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u88ab\u62d2\u7edd", (String)"CompanyBatchPayQueryImpl_6", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)TransStatus, (String)errorMsg);
        } else if ("8".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)TransStatus, (String)errorMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)TransStatus, (String)errorMsg);
        }
        return tempInfo;
    }

    private static String getBankDataKey(String incomeNo, String incomeName, String amount) {
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }
}

