/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citi.dc.services.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractACKHandler;
import kd.ebg.aqap.proxy.oversea.utils.JDom11Utils;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CITI_DC_PAY_ACK_XML_Handler
extends AbstractACKHandler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CITI_DC_PAY_ACK_XML_Handler.class);

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return this.isFileLevelACK(fileName) || this.isTransactionLevelACK(fileName);
    }

    private boolean isFileLevelACK(String fileName) {
        return fileName.contains("ACK");
    }

    private boolean isTransactionLevelACK(String fileName) {
        return fileName.contains("ACCEPT") || fileName.contains("REJ");
    }

    protected List<PaymentInfo> processFile(File file) {
        List<Object> list = Lists.newArrayList();
        try {
            if (this.isFileLevelACK(file.getName())) {
                list = this.processFileLevelACK(file);
            } else if (this.isTransactionLevelACK(file.getName())) {
                list = this.processTransactionLevelACK(file);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"CITI_DC_PAY_ACK_XML_Handler_3", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), file.getName(), e));
        }
        return list;
    }

    private List<PaymentInfo> processFileLevelACK(File file) throws Exception {
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String batchId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
        this.logger.info(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6279\u6b21\u53f7\u67e5\u8be2\u5230%1$s\u7b14\u8bb0\u5f55\u3002", (String)"CITI_DC_PAY_ACK_XML_Handler_4", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), payInfoList.size()));
        String GrpSts = orgnlgst.getChildText("GrpSts", ns);
        Element StsRsnInf = orgnlgst.getChild("StsRsnInf", ns);
        String txMsg = GrpSts;
        if (StsRsnInf != null) {
            txMsg = StsRsnInf.getChildText("AddtlInf", ns);
        }
        this.logger.info(String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7:%1$s\uff0cGrpSts:%2$s\uff0cAddtlInf:%3$s\u3002", (String)"CITI_DC_PAY_ACK_XML_Handler_5", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), new Object[0]), new Object[]{batchId, GrpSts, txMsg});
        for (PaymentInfo paymentInfo : payInfoList) {
            if (GrpSts.startsWith("AC") && GrpSts.length() == 4) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CITI_DC_PAY_ACK_XML_Handler_0", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CITI_DC_PAY_ACK_XML_Handler_1", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
        }
        return payInfoList;
    }

    protected List<PaymentInfo> processTransactionLevelACK(File file) throws Exception {
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String batchId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List pmtList = cstrpt.getChildren("OrgnlPmtInfAndSts", ns);
        HashMap<String, PaymentInfo> map = new HashMap<String, PaymentInfo>(16);
        for (Element ele : pmtList) {
            String inf;
            Element TxInfAndSts = JDom11Utils.getChildElement((Element)ele, (String)"TxInfAndSts", (Namespace)ns);
            String seqId = TxInfAndSts.getChildText("OrgnlEndToEndId", ns);
            String TxSts = TxInfAndSts.getChildText("TxSts", ns);
            Element StsRsnInf = TxInfAndSts.getChild("StsRsnInf", ns);
            String txMsg = TxSts;
            if (StsRsnInf != null && !StringUtils.isEmpty((String)(inf = StsRsnInf.getChildText("AddtlInf", ns))) && inf.contains("/")) {
                inf = inf.substring(1, inf.length());
                txMsg = inf.substring(inf.indexOf("/") + 1);
                this.logger.info(String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7:%1$s\uff0cTxSts:%2$s\uff0cAddtlInf:%3$s\u3002", (String)"CITI_DC_PAY_ACK_XML_Handler_6", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), batchId, TxSts, txMsg));
            }
            PaymentInfo paymentInfo = new PaymentInfo();
            paymentInfo.setBankStatus(TxSts);
            paymentInfo.setBankMsg(txMsg);
            map.put(seqId, paymentInfo);
        }
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
        this.logger.info("\u6839\u636e\u6279\u6b21\u53f7\u67e5\u8be2\u5230" + payInfoList.size() + "\u7b14\u8bb0\u5f55");
        for (PaymentInfo paymentInfo : payInfoList) {
            PaymentInfo info = (PaymentInfo)map.get(paymentInfo.getBankDetailSeqID());
            if (info == null) continue;
            String status = info.getBankStatus();
            String txMsg = info.getBankMsg();
            if ("RJCT".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CITI_DC_PAY_ACK_XML_Handler_1", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), (String)status, (String)txMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CITI_DC_PAY_ACK_XML_Handler_0", (String)"ebg-aqap-banks-citi-dc", (Object[])new Object[0]), (String)status, (String)txMsg);
        }
        return payInfoList;
    }
}

