/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzc.dc.service.balance;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzc.dc.service.GZC_DC_Packer;
import kd.ebg.aqap.banks.gzc.dc.service.GZC_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchBalanceImpl
extends AbstractBalanceImpl
implements IBatchBalance,
IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BatchBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = GZC_DC_Packer.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element tranList = new Element("AcList");
        List bankAcntList = bankBalanceRequest.getBankAcntList();
        ArrayList<Element> list = new ArrayList<Element>(16);
        Element acct = new Element("ACCT_CCY_CD");
        acct.setText(bankBalanceRequest.getBankCurrency());
        for (BankAcnt b : bankAcntList) {
            Element element = new Element("Map");
            Element accNo = new Element("AC_NO");
            accNo.setText(b.getAccNo());
            JDomUtils.addChild((Element)element, (Element)accNo);
            JDomUtils.addChild((Element)element, (Element)acct);
            list.add(element);
        }
        tranList.addContent(list);
        JDomUtils.addChild((Element)body, (Element)tranList);
        String encoding = EBContext.getContext().getCharsetName();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse headRsp = GZC_DC_Parser.parseINFO(root);
        if (!"00000000".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8d63\u5dde\u94f6\u884c\u54cd\u5e94\u7801:%1$s;\u51fa\u9519\u539f\u56e0\u4e3a:%2$s\u3002", (String)"BatchBalanceImpl_3", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), headRsp.getResponseCode(), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("Body");
        Element tranList = body.getChild("List");
        List list = tranList.getChildren("Map");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < list.size(); ++i) {
            Element node = (Element)list.get(i);
            BalanceInfo info = new BalanceInfo();
            String accNo = node.getChildTextTrim("AC_NO");
            String acctCcyCd = node.getChildTextTrim("ACCT_CCY_CD");
            String balance = node.getChildTextTrim("Balance");
            String availBal = node.getChildTextTrim("AvailBal");
            log.info("\u89e3\u6790\u5230\u8d63\u5dde\u94f6\u884c\u8fd4\u56de\u7684'\u5f53\u524d\u4f59\u989d'\u4e3a" + balance + " \u2018\u53ef\u7528\u4f59\u989d\u2019\u4e3a" + availBal);
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accNo);
            info.setBankAcnt(bankAcnt);
            info.setBankCurrency(StringUtils.isEmpty((String)acctCcyCd) ? bankBalanceRequest.getHeader().getBankCurrency() : acctCcyCd);
            this.setCurrentBalance(info, balance);
            this.setAvailableBalance(info, availBal);
            balances.add(info);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "10000000";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"BatchBalanceImpl_2", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]);
    }

    public int limit() {
        return 10;
    }

    public boolean async() {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
    }
}

