/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzc.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzc.dc.service.GZC_DC_Packer;
import kd.ebg.aqap.banks.gzc.dc.service.GZC_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public static final int PageSize = 10;

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        Element root = GZC_DC_Packer.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AC_NO", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"ACCT_CCY_CD", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate(), (String)"yyyyMMdd"));
        String pageTag = this.getCurrentPage();
        if (StringUtils.isEmpty((String)pageTag) || "0".equalsIgnoreCase(pageTag)) {
            this.setCurrentPage(1);
        }
        JDomUtils.addChild((Element)body, (String)"PageIndex", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"PageSize", (String)String.valueOf(10));
        String encoding = EBContext.getContext().getCharsetName();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse response = new EBBankDetailResponse(this.parseDetails(request, responseStr));
        return response;
    }

    private List<DetailInfo> parseDetails(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse headRsp = GZC_DC_Parser.parseINFO(root);
        if (!"00000000".equals(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8d63\u5dde\u94f6\u884c\u54cd\u5e94\u7801:%1$s;\u51fa\u9519\u539f\u56e0\u4e3a:%2$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]), headRsp.getResponseCode(), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("Body");
        String size = body.getChildTextTrim("Size");
        if ("0".equalsIgnoreCase(size)) {
            this.setLastPage(true);
            return detailList;
        }
        int page = Integer.parseInt(this.getCurrentPage()) + 1;
        this.setCurrentPage(page);
        if (StringUtils.isNotEmpty((String)size)) {
            if (Integer.parseInt(size) < 10) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
            }
        } else {
            this.setLastPage(true);
        }
        Element tranList = body.getChild("List");
        List list = tranList.getChildren("Map");
        for (int i = 0; i < list.size(); ++i) {
            Element node = (Element)list.get(i);
            String refnbr = node.getChildTextTrim("REFNBR");
            String etydat = node.getChildTextTrim("ETYDAT");
            String etytim = node.getChildTextTrim("ETYTIM");
            String debitLndFlg = node.getChildTextTrim("DEBIT_LND_FLG");
            String pyAcctNo = node.getChildTextTrim("PyAcctNo");
            String amount = node.getChildTextTrim("Amount");
            String txCntptyAcctNum = node.getChildTextTrim("TX_CNTPTY_ACCT_NUM");
            String txnCntptyNm = node.getChildTextTrim("TXN_CNTPTY_NM");
            String acctCcyCd = node.getChildTextTrim("ACCT_CCY_CD");
            String remark = node.getChildTextTrim("Remark");
            String uses1 = node.getChildTextTrim("Uses1");
            DetailInfo detail = new DetailInfo();
            detail.setTransDate(LocalDate.parse(etydat, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            detail.setTransTime(LocalDateTime.parse(etydat + " " + etytim, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            BigDecimal payAmountD = new BigDecimal(amount);
            BigDecimal recAmountD = new BigDecimal(amount);
            if (debitLndFlg.equalsIgnoreCase("0")) {
                detail.setDebitAmount(payAmountD);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (debitLndFlg.equalsIgnoreCase("1")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(recAmountD);
            } else {
                detail.setDebitAmount(payAmountD);
                detail.setCreditAmount(recAmountD);
            }
            detail.setAccNo(pyAcctNo);
            detail.setOppAccNo(txCntptyAcctNum);
            detail.setOppAccName(txnCntptyNm);
            detail.setCurrency(acctCcyCd);
            detail.setUseCn(uses1);
            detail.setExplanation(remark);
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(node);
            detail.setJsonMap(jsonStr);
            String accNo = rqst.getHeader().getAcnt().getAccNo();
            String transDate = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(refnbr);
            detailList.add(detail);
        }
        return detailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "10000001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-aqap-banks-gzc-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
    }
}

