/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jxnx.dc.services.payment;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnx.dc.services.Parser;
import kd.ebg.aqap.banks.jxnx.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.jxnx.dc.util.FactoryUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        return FactoryUtil.setFactory(factory, "B2EBatchTransfer");
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EBatchTransfer");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)paymentInfo.getBankBatchSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (PaymentInfo payInfo : paymentInfos) {
            Element map = JDomUtils.addChild((Element)list, (String)"Map");
            if (payInfo.is2SameBank()) {
                JDomUtils.addChild((Element)map, (String)"TransferType", (String)"001");
            } else {
                JDomUtils.addChild((Element)map, (String)"TransferType", (String)"002");
            }
            JDomUtils.addChild((Element)map, (String)"TransferJnlNo", (String)payInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)payInfo.getAccName());
            JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)payInfo.getAccNo());
            JDomUtils.addChild((Element)map, (String)"PayerCurrency", (String)payInfo.getCurrency());
            JDomUtils.addChild((Element)map, (String)"PayeeCurrency", (String)payInfo.getCurrency());
            JDomUtils.addChild((Element)map, (String)"PayerBankAcType", (String)"C6");
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)payInfo.getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)payInfo.getIncomeAccNo());
            if (payInfo.is2SameBank()) {
                JDomUtils.addChild((Element)map, (String)"PayeeBankAcType", (String)"C6");
            } else {
                JDomUtils.addChild((Element)map, (String)"PayeeBankAcType", (String)"");
            }
            JDomUtils.addChild((Element)map, (String)"Amount", (String)payInfo.getAmount().toString());
            if (!payInfo.is2SameBank() && StringUtils.isEmpty((String)payInfo.getIncomeCnaps())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26\uff0c\u8054\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)map, (String)"UnionDeptId", (String)payInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)map, (String)"Priority", (String)"1");
            JDomUtils.addChild((Element)map, (String)"Remark", (String)payInfo.getExplanation());
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader(root);
        if (!"000000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        List maps = list.getChildren("Map");
        if (null == maps || maps.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u8fd4\u56de\u7684<Map>\u8282\u70b9\u4e3a\u7a7a.\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001.", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String returnCode = map.getChildTextTrim("ReturnCode");
            String returnMsg = map.getChildTextTrim("ReturnMsg");
            String payerAcNo = map.getChildTextTrim("PayerAcNo");
            String payeeAcNo = map.getChildTextTrim("PayeeAcNo");
            String payeeAcName = map.getChildTextTrim("PayeeAcName");
            String amount = map.getChildTextTrim("Amount");
            PaymentInfo paymentInfo = PaymentImpl.selectPaymentInfo(bankPayRequest.getPaymentInfoAsArray(), payerAcNo, payeeAcNo, payeeAcName, amount);
            if (null == paymentInfo) continue;
            if ("000000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !"income".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public static PaymentInfo selectPaymentInfo(PaymentInfo[] infos, String payerAcNo, String incomeAccNo, String incomeName, String amount) {
        BigDecimal formatedAmount = BigDecimalHelper.str2BigDecimal((String)amount);
        String amoutStr = BigDecimalHelper.plain2((BigDecimal)formatedAmount);
        formatedAmount = BigDecimalHelper.str2BigDecimal((String)amoutStr);
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].getAccNo().equals(payerAcNo) || !infos[i].getIncomeAccNo().equals(incomeAccNo) || !infos[i].getIncomeAccName().equals(incomeName) || !infos[i].getAmount().equals(formatedAmount)) continue;
            return infos[i];
        }
        return null;
    }
}

