/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bxw.opa.services.pay;

import com.alibaba.fastjson.JSONObject;
import com.xwbank.sdk.entity.singlepayment.SinglePaymentInfo;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bxw.opa.services.pay.QryPaymentImpl;
import kd.ebg.aqap.banks.bxw.opa.services.utils.XWBResponse;
import kd.ebg.aqap.banks.bxw.opa.services.utils.XWUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse doBiz(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String customID = EBContext.getContext().getCustomID();
        try {
            String appID = RequestContextUtils.getBankParameterValue((String)"appID");
            String canal = RequestContextUtils.getBankParameterValue((String)"canal");
            SinglePaymentInfo singlePaymentInfo = new SinglePaymentInfo();
            singlePaymentInfo.setAppId(appID);
            singlePaymentInfo.setVersion("1.0");
            singlePaymentInfo.setMcht_no(canal);
            String trans_no = paymentInfo.getBankDetailSeqID() + paymentInfo.getBatchSeqID().substring(0, 13);
            singlePaymentInfo.setTran_no(trans_no);
            singlePaymentInfo.setPriority("HIGH");
            singlePaymentInfo.setPayer_acct_no(paymentInfo.getAccNo());
            singlePaymentInfo.setPayer_acct_name(paymentInfo.getAccName());
            singlePaymentInfo.setPayee_acct_no(paymentInfo.getIncomeAccNo());
            singlePaymentInfo.setPayee_acct_name(paymentInfo.getIncomeAccName());
            singlePaymentInfo.setCcy("CNY");
            singlePaymentInfo.setAmt(paymentInfo.getAmount().setScale(2, 1).toString());
            singlePaymentInfo.setRemark(paymentInfo.getExplanation());
            singlePaymentInfo.setPurpose(paymentInfo.getExplanation());
            singlePaymentInfo.setMsg_spare("00001");
            if (paymentInfo.is2Individual()) {
                if (paymentInfo.getExplanation().contains(ResManager.loadKDString((String)"\u4fe1\u7528\u5361", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]))) {
                    singlePaymentInfo.setPayee_acct_type("CREDIT");
                } else {
                    singlePaymentInfo.setPayee_acct_type("DEBIT");
                }
            } else {
                singlePaymentInfo.setPayee_acct_type("PUBLIC");
                if (!StringUtils.isEmpty((String)paymentInfo.getIncomeCnaps())) {
                    singlePaymentInfo.setPayee_op_bank_code(paymentInfo.getIncomeCnaps());
                }
            }
            XWBResponse xwbResponse = XWUtil.send(singlePaymentInfo, customID);
            if (!xwbResponse.isSuccess()) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f:%s\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), xwbResponse.getResponseMessage()));
            }
            JSONObject resp = xwbResponse.getData();
            String deal_result = resp.getString("deal_result");
            String return_code = resp.getString("return_code");
            String return_message = resp.getString("return_message");
            if (StringUtils.isEmpty((String)deal_result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), (String)return_code, (String)return_message);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4ea4\u6613\u72b6\u6001\u5f02\u5e38\uff0c\u72b6\u6001\u7801%1$s\uff0c\u8fd4\u56de\u4fe1\u606f%2$s\u3002", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), return_code, return_message));
            }
            if ("0".equalsIgnoreCase(deal_result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), (String)return_code, (String)return_message);
            } else if ("1".equalsIgnoreCase(deal_result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), (String)return_code, (String)return_message);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), (String)return_code, (String)return_message);
            }
            return new EBBankPayResponse(paymentInfos);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

