/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bxw.opa.services.utils;

import com.alibaba.fastjson.JSONObject;
import com.xwbank.sdk.XWBankSDK;
import com.xwbank.sdk.entity.acctranshistoryquery.AccTransHistoryQueryInfo;
import com.xwbank.sdk.entity.querybalance.QueryBalanceInfo;
import com.xwbank.sdk.entity.singlepayment.SinglePaymentInfo;
import com.xwbank.sdk.entity.singletransstatusquery.SingleTransStatusQueryInfo;
import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.http.entity.InitParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.ReflectionUtils;
import kd.ebg.aqap.banks.bxw.opa.services.utils.KeyStoreUtil;
import kd.ebg.aqap.banks.bxw.opa.services.utils.XWBResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import org.apache.commons.io.FilenameUtils;

public class XWUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(XWUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XWStruct buildPropFile(String customerID) {
        boolean isSucc;
        Properties prop = new Properties();
        XWStruct st = new XWStruct();
        String certCipher = RequestContextUtils.getBankParameterValue((String)"cert_cipher");
        String appID = RequestContextUtils.getBankParameterValue((String)"appID");
        String url = RequestContextUtils.getBankParameterValue((String)"ip");
        String serverPK = KeyStoreUtil.getServerPK();
        prop.setProperty("open.sdk.pwd", certCipher);
        prop.setProperty("open.sdk.appId", appID);
        prop.setProperty("open.sdk.url", url);
        prop.setProperty("open.sdk.publicKey", serverPK);
        String configPath = System.getProperty("user.dir") + File.separator + "BXW" + File.separator + customerID;
        File fp = FileCommonUtils.getFileByPath((String)configPath);
        if (!fp.exists() && !(isSucc = fp.mkdirs())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519", (String)"XWUtil_0", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]));
        }
        File configFile = FileCommonUtils.getFileByPath((String)(configPath + File.separator + "config.properties"));
        try (FileOutputStream os = new FileOutputStream(configFile);){
            prop.store(os, "");
            st.setFileName(configPath + File.separator + "config.properties");
            st.setPath(configFile.toPath());
            XWStruct xWStruct = st;
            return xWStruct;
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XWStruct createFile(String name, String customerID, byte[] content) {
        boolean isSucc;
        String configPath = System.getProperty("user.dir") + File.separator + "BXW" + File.separator + customerID;
        XWStruct st = new XWStruct();
        String fileName = FilenameUtils.getName((String)(configPath + File.separator + name));
        File fp = FileCommonUtils.getFileByPath((String)configPath);
        if (!fp.exists() && !(isSucc = fp.mkdirs())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519", (String)"XWUtil_0", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]));
        }
        try {
            Path path = Paths.get(fileName, new String[0]);
            Files.deleteIfExists(Paths.get(fileName, new String[0]));
            Files.createFile(path, new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                os.write(content);
                os.flush();
                st.setFileName(fileName);
                st.setPath(path);
                XWStruct xWStruct = st;
                return xWStruct;
            }
        }
        catch (Exception e) {
            logger.info("\u6587\u4ef6\u521b\u5efa\u8fc7\u7a0b\u51fa\u9519", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static XWBankSDK initSDK(String customerID) throws IllegalAccessException {
        XWStruct fileParam1 = XWUtil.buildPropFile(customerID);
        XWStruct fileParam2 = XWUtil.createFile("user.sm2", customerID, KeyStoreUtil.getUserCert());
        XWStruct fileParam3 = XWUtil.createFile("SM2oca31Test.cer", customerID, KeyStoreUtil.getCertChain());
        InitParam param = new InitParam(fileParam1.getFileName(), fileParam2.getFileName(), fileParam3.getFileName());
        Field f = ReflectionUtils.findField(XWBankSDK.class, (String)"isInit");
        ReflectionUtils.makeAccessible((Field)f);
        Boolean isInit = (Boolean)f.get(XWBankSDK.class);
        if (Boolean.FALSE.equals(isInit)) {
            if (XWBankSDK.getInstance().init(param)) {
                return XWBankSDK.getInstance();
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"SDK\u521d\u59cb\u5316\u5f02\u5e38\u3002", (String)"XWUtil_1", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]));
        }
        ReflectionUtils.setField((Field)f, XWBankSDK.class, (Object)false);
        if (XWBankSDK.getInstance().init(param)) {
            return XWBankSDK.getInstance();
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"SDK\u521d\u59cb\u5316\u5f02\u5e38\u3002", (String)"XWUtil_1", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]));
    }

    public static XWBResponse send(QueryBalanceInfo queryBalanceInfo, String customID) throws IllegalAccessException, SDKException {
        XWBankSDK sdk = XWUtil.initSDK(customID);
        XWBResponse xwbResponse = new XWBResponse();
        JSONObject reqJson = (JSONObject)JSONObject.toJSON((Object)queryBalanceInfo);
        logger.info("\u8bf7\u6c42json\u6570\u636e\u4e3a" + reqJson.toJSONString());
        Map retMap = sdk.queryBalance(queryBalanceInfo);
        JSONObject respJson = (JSONObject)JSONObject.toJSON((Object)retMap);
        logger.info("\u54cd\u5e94json\u6570\u636e\u4e3a" + respJson.toJSONString());
        String returnCode = respJson.getString("returnCode");
        String returnMsg = respJson.getString("returnMsg");
        xwbResponse.setResponseCode(returnCode);
        xwbResponse.setResponseMessage(returnMsg);
        JSONObject data = respJson.getJSONObject("data");
        xwbResponse.setData(data);
        return xwbResponse;
    }

    public static XWBResponse send(AccTransHistoryQueryInfo accTransHistoryQueryInfo, String customID) throws IllegalAccessException, SDKException {
        XWBankSDK sdk = XWUtil.initSDK(customID);
        XWBResponse xwbResponse = new XWBResponse();
        JSONObject reqJson = (JSONObject)JSONObject.toJSON((Object)accTransHistoryQueryInfo);
        logger.info("\u8bf7\u6c42json\u6570\u636e\u4e3a" + reqJson.toJSONString());
        Map retMap = sdk.accTransHistoryQuery(accTransHistoryQueryInfo);
        JSONObject respJson = (JSONObject)JSONObject.toJSON((Object)retMap);
        logger.info("\u54cd\u5e94json\u6570\u636e\u4e3a" + respJson.toJSONString());
        String returnCode = respJson.getString("returnCode");
        String returnMsg = respJson.getString("returnMsg");
        xwbResponse.setResponseCode(returnCode);
        xwbResponse.setResponseMessage(returnMsg);
        JSONObject data = respJson.getJSONObject("data");
        xwbResponse.setData(data);
        return xwbResponse;
    }

    public static XWBResponse send(SinglePaymentInfo singlePaymentInfo, String customID) throws IllegalAccessException, SDKException {
        XWBankSDK sdk = XWUtil.initSDK(customID);
        XWBResponse xwbResponse = new XWBResponse();
        JSONObject reqJson = (JSONObject)JSONObject.toJSON((Object)singlePaymentInfo);
        logger.info("\u8bf7\u6c42json\u6570\u636e\u4e3a" + reqJson.toJSONString());
        Map retMap = sdk.singlePayment(singlePaymentInfo);
        JSONObject respJson = (JSONObject)JSONObject.toJSON((Object)retMap);
        logger.info("\u54cd\u5e94json\u6570\u636e\u4e3a" + respJson.toJSONString());
        String returnCode = respJson.getString("returnCode");
        String returnMsg = respJson.getString("returnMsg");
        xwbResponse.setResponseCode(returnCode);
        xwbResponse.setResponseMessage(returnMsg);
        JSONObject data = respJson.getJSONObject("data");
        xwbResponse.setData(data);
        return xwbResponse;
    }

    public static XWBResponse send(SingleTransStatusQueryInfo singleTransStatusQueryInfo, String customID) throws IllegalAccessException, SDKException {
        XWBankSDK sdk = XWUtil.initSDK(customID);
        XWBResponse xwbResponse = new XWBResponse();
        JSONObject reqJson = (JSONObject)JSONObject.toJSON((Object)singleTransStatusQueryInfo);
        logger.info("\u8bf7\u6c42json\u6570\u636e\u4e3a" + reqJson.toJSONString());
        Map retMap = sdk.singleTransStatusQuery(singleTransStatusQueryInfo);
        JSONObject respJson = (JSONObject)JSONObject.toJSON((Object)retMap);
        logger.info("\u54cd\u5e94json\u6570\u636e\u4e3a" + respJson.toJSONString());
        String returnCode = respJson.getString("returnCode");
        String returnMsg = respJson.getString("returnMsg");
        xwbResponse.setResponseCode(returnCode);
        xwbResponse.setResponseMessage(returnMsg);
        JSONObject data = respJson.getJSONObject("data");
        xwbResponse.setData(data);
        return xwbResponse;
    }

    static class XWStruct {
        private String fileName;
        private Path path;

        XWStruct() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }
    }
}

