/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.services.detail.CashPoolDetailPacker;
import kd.ebg.aqap.banks.xtb.dc.services.detail.CashPoolDetailParser;
import kd.ebg.aqap.banks.xtb.dc.utils.CashPoolHelper;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger ebgLogger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private final String trade_code = "200110";

    public String pack(BankDetailRequest bankDetailRequest) {
        if (CashPoolHelper.isCashPoolAcnt(bankDetailRequest.getAcnt().getAccNo())) {
            return new CashPoolDetailPacker().packCashPoolDetail(bankDetailRequest);
        }
        return this.packNormal(bankDetailRequest);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        EBBankDetailResponse ebBankDetailResponse = new EBBankDetailResponse();
        if (CashPoolHelper.isCashPoolAcnt(bankDetailRequest.getAcnt().getAccNo())) {
            List<DetailInfo> detailInfos = new CashPoolDetailParser().parseCashPoolDetail(bankDetailRequest, s);
            ebBankDetailResponse.setDetails(detailInfos);
            return ebBankDetailResponse;
        }
        List<DetailInfo> detailInfos = this.parseTodayDetail(bankDetailRequest, s);
        ebBankDetailResponse.setDetails(detailInfos);
        return ebBankDetailResponse;
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest arg0, String arg1) {
        ebgLogger.info(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u6587\u7684\u65f6\u95f4\uff1a%s\u3002", (String)"DetailImpl_13", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), System.currentTimeMillis()));
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)TCommon.parseRecvMsg(arg1), (String)encoding);
        Element head = ebenk.getChild("head");
        if (!"0000".equals(head.getChildTextTrim("ret_code"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u80fd\u6b63\u5e38\u8fd4\u56de\uff0c\u8fd4\u56de\u7801\uff1a%s\u3002", (String)"DetailImpl_14", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), head.getChildTextTrim("ret_code")) + "\n" + String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u9644\u52a0\u4fe1\u606f%s\u3002", (String)"DetailImpl_15", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), head.getChildText("ext_info"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if (!"0".equals(head.getChildTextTrim("succ_flag"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_16", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), head.getChildText("ext_info"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = ebenk.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        String content = null;
        if (recordNum <= 0) {
            ebgLogger.error(ResManager.loadKDString((String)"###\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            return details;
        }
        if ("0".equals(head.getChildTextTrim("file_flag"))) {
            String serial_record;
            ebgLogger.info(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u662f\u62a5\u6587\uff0c\u4eceserial_record\u91cc\u9762\u62ff\u5230\u4fe1\u606f\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            content = serial_record = body.getChildTextTrim("serial_record");
        } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
            ebgLogger.info(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u662f\u6587\u4ef6", (String)"DetailImpl_6", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            ebgLogger.info(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u6587\u4ef6\u7684\u65f6\u95f4\uff1a%s\u3002", (String)"DetailImpl_17", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), System.currentTimeMillis()));
            String file_name = body.getChildTextTrim("file_name");
            content = IOUtils.downloadFileFromLocal(file_name);
            ebgLogger.info(String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u8bfb\u6587\u4ef6\u7684\u65f6\u95f4\uff1a%s\u3002", (String)"DetailImpl_18", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), System.currentTimeMillis()));
        }
        String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
        for (int k = 0; k < rs.length; ++k) {
            String[] rs_k = rs[k];
            DetailInfo detailInfo = this.parseRecord(rs_k);
            details.add(detailInfo);
        }
        ebgLogger.info(ResManager.loadKDString((String)"===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===", (String)"DetailImpl_9", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        return details;
    }

    private DetailInfo parseRecord(String[] r2_k) {
        String acno = r2_k[1];
        String tr_currency = r2_k[2];
        String tr_acdt = r2_k[3];
        String tr_time = r2_k[4];
        String host_serial_no = r2_k[5];
        String tranDate = "";
        String acname = r2_k[7];
        String opp_acno = r2_k[8];
        String opp_acname = r2_k[10];
        String oppBank = r2_k[11];
        String crdr_flag = r2_k[23];
        String amt = r2_k[24];
        String balance = r2_k[25];
        String summary = r2_k[34];
        String postscript = r2_k[35];
        String payamt = r2_k[43];
        String rcvamt = r2_k[44];
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(acno);
        detailInfo.setAccName(acname);
        detailInfo.setOppAccNo(opp_acno);
        detailInfo.setOppAccName(opp_acname);
        detailInfo.setBankName(oppBank);
        detailInfo.setCurrency(tr_currency);
        try {
            if (!StringUtils.isEmpty((String)tr_acdt)) {
                tranDate = !StringUtils.isEmpty((String)tr_time) ? tr_acdt + tr_time : tr_acdt;
                detailInfo.setTransTime(LocalDateTime.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                detailInfo.setTransDate(detailInfo.getTransTime().toLocalDate());
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u4ea4\u6613\u65e5\u671f\u5f02\u5e38:%s\u3002", (String)"DetailImpl_19", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), tranDate), (Throwable)e);
        }
        if ("D".equalsIgnoreCase(crdr_flag)) {
            detailInfo.setDebitAmount(new BigDecimal(payamt));
            detailInfo.setCreditAmount(new BigDecimal("0.00"));
        }
        if ("C".equalsIgnoreCase(crdr_flag)) {
            detailInfo.setDebitAmount(new BigDecimal("0.00"));
            detailInfo.setCreditAmount(new BigDecimal(rcvamt));
        }
        if (!StringUtils.isEmpty((String)summary)) {
            detailInfo.setExplanation(summary);
        } else {
            detailInfo.setExplanation(postscript);
        }
        detailInfo.setBalance(new BigDecimal(balance));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tr_acdt", (Object)tr_acdt);
        jsonObject.put("host_serial_no", (Object)host_serial_no);
        jsonObject.put("crdr_flag", (Object)crdr_flag);
        jsonObject.put("amt", (Object)amt);
        jsonObject.put("purpose", (Object)summary);
        jsonObject.put("postscript", (Object)postscript);
        detailInfo.setJsonMap(jsonObject.toJSONString());
        detailInfo.setBankDetailNo(host_serial_no);
        return detailInfo;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "200103,200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5206\u5f52\u96c6\u8d26\u6237\u548c\u666e\u901a\u8d26\u6237\u3002", (String)"DetailImpl_11", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }

    public String packNormal(BankDetailRequest request) {
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("200110", "0"));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(request));
        String encoding = RequestContextUtils.getCharset();
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(rqstStr);
    }

    private Element getDetailRequestBody(BankDetailRequest request) {
        String timeFormat = "yyyyMMdd";
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        ebgLogger.info(request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        ebgLogger.info(request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return body;
    }
}

