/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment;

import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2(this.getBizCode(), paymentInfos, "0"));
        Element body = new Element("body");
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)"");
        JDomUtils.addChild((Element)body, (String)"req_no", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)paymentInfos[0].getRequestTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(requestMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        log.info("\u63a5\u53d7\u5230\u7684\u62a5\u6587\u4fe1\u606f\u4e3a\uff1a" + rspStr);
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        Element body = bank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            ebBankPayResponse.setPaymentInfos(bankPayRequest.getPaymentInfos());
            return ebBankPayResponse;
        }
        String TransStatus = body.getChildTextTrim("stat");
        if ("9".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        } else if ("6".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        } else if ("7".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u88ab\u62d2\u7edd", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u88ab\u62d2\u7edd", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPaymentImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        }
        ebBankPayResponse.setPaymentInfos(bankPayRequest.getPaymentInfos());
        return ebBankPayResponse;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "200205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u72b6\u6001\u67e5\u8be2", (String)"QueryPaymentImpl_5", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }
}

