/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment.salary.batch;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.services.payment.salary.batch.SalaryBatchQueryPaymentImpl;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryBatchPaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryBatchPaymentImpl.class);
    private final String TRANCODE = "300002";

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryBatchQueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2("300002", paymentInfos, "1"));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfos[0].getBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0001");
        StringBuilder content = new StringBuilder("acno|cur_code|acname|cardflag|amt|postscript|\r\n");
        BigDecimal totalamount = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            content.append(paymentInfos[i].getIncomeAccNo()).append("|").append(paymentInfos[i].getCurrency()).append("|").append(paymentInfos[i].getIncomeAccName()).append("|").append("|").append(paymentInfos[i].getAmount()).append("|").append(paymentInfos[i].getExplanation()).append("|\r\n");
            totalamount = totalamount.add(paymentInfos[i].getAmount());
        }
        String bankBatchSeqId = paymentInfos[0].getBatchSeqId();
        Date now = new Date();
        String date = DateTimeUtils.format((Date)now, (String)"yyyyMMddHHmmss");
        String filename = bankBatchSeqId + "@" + date;
        IOUtils.uploadFileFromLocal(filename, content.toString());
        JDomUtils.addChild((Element)body, (String)"amt", (String)totalamount.toString());
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfos[0].getExplanation());
        JDomUtils.addChild((Element)body, (String)"file_name", (String)filename);
        String requestXml = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        this.logger.info("\u4ee3\u53d1\u8bf7\u6c42\u62a5\u6587\uff0c\u5185\u5bb9\uff1a" + TCommon.createCommonMsg(requestXml));
        return TCommon.createCommonMsg(requestXml);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        this.logger.info("\u63a5\u53d7\u5230\u7684\u62a5\u6587\u4fe1\u606f\u4e3a\uff1a" + rspStr);
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryBatchPaymentImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryBatchPaymentImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\uff0c\u4ea4\u6613\u7801\uff1a300002", (String)"SalaryBatchPaymentImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

