/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.payment.batch.BatchPayImpl;
import kd.ebg.aqap.banks.spdb.dc.services.payment.company.CompanyPaymentImpl;
import kd.ebg.aqap.banks.spdb.dc.services.payment.individual.PayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.setPayRouteTrace(paymentInfo, this.getBusiImplInfo(paymentInfo));
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("accNo=").append(paymentInfo.getAccNo());
        packageKey.append(';');
        packageKey.append("sameBank=").append(paymentInfo.is2SameBank());
        packageKey.append(';');
        packageKey.append("urgent=").append(paymentInfo.is2Urgent());
        packageKey.append(';');
        String subBizType = paymentInfo.getSubBizType();
        if ("income".equals(subBizType)) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u4e0a\u6d77\u6d66\u4e1c\u53d1\u5c55\u94f6\u884c\u6682\u4e0d\u652f\u6301\u6279\u6263\u4e1a\u52a1\u3002", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        if (this.isPay_for_salary(paymentInfo)) {
            this.setSubBizType4Salary(paymentInfo, busiImplInfo);
        } else if (this.isPay_for_capital_allocation(paymentInfo) || this.isTransferUseCN(paymentInfo) && this.isPay(paymentInfo)) {
            this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
        } else if (this.isPay(paymentInfo)) {
            if (!this.deterMineCurrency(paymentInfo.getCurrency())) {
                paymentInfo.setIndividual(Boolean.valueOf(false));
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.spdb.dc.services.payment.foreign.PayImpl.class.getName());
            } else if (this.isTransferUseCN(paymentInfo)) {
                this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
            } else if (this.isIndividual(paymentInfo) && this.deterMineCurrency(paymentInfo.getCurrency())) {
                paymentInfo.setIndividual(Boolean.valueOf(true));
                this.setImplClassName(paymentInfo, PayImpl.class.getName());
            } else {
                paymentInfo.setIndividual(Boolean.valueOf(false));
                this.setImplClassName(paymentInfo, CompanyPaymentImpl.class.getName());
            }
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            paymentInfo.setImplClassName(null);
        } else {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u7c7b\u578b%s\u672a\u5b9e\u73b0\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), subBizType));
        }
        busiImplInfo.setPackageKey(packageKey.toString());
        return busiImplInfo;
    }

    public boolean deterMineCurrency(String currency) {
        boolean result = "01".equalsIgnoreCase(currency);
        if (result) {
            this.addRoute(false, "Currency", currency);
        }
        return result;
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) throws EBServiceException {
        if (!this.isUse8802ForSalary()) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.spdb.dc.services.payment.salary.PayImpl.class.getName());
            return;
        }
        if (this.isUse8802ForSalary()) {
            this.setImplClassName(paymentInfo, BatchPayImpl.class.getName());
            return;
        }
    }

    public boolean isUse8802ForSalary() {
        return this.assertBusinessConfig("spdb_dc_salary_select", "8802");
    }

    private void setSubBizType4CapitalAllocation(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) throws EBServiceException {
        paymentInfo.setIndividual(Boolean.valueOf(false));
        if (BankBusinessConfig.isTransferToCompany().booleanValue()) {
            paymentInfo.setImplClassName(CompanyPaymentImpl.class.getName());
            this.setImplClassName(paymentInfo, CompanyPaymentImpl.class.getName());
        } else {
            paymentInfo.setImplClassName(kd.ebg.aqap.banks.spdb.dc.services.payment.allocation.PayImpl.class.getName());
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.spdb.dc.services.payment.allocation.PayImpl.class.getName());
        }
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

