/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.another;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BankResponseResult;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayContentUtils {
    private static final String SPLITSTR = "|";
    private static final String[] FAILEDCODES = new String[]{"1"};
    private static final String[] SUCCESSCODES = new String[]{"0"};
    public static final String ENTRUSTSEQNO = "entrustSeqNo";

    public static Map<String, BankResponseResult> parseResult(List<Element> list) {
        int capacity = (int)((double)list.size() / 0.75 + 1.0);
        HashMap<String, BankResponseResult> resultMap = new HashMap<String, BankResponseResult>(capacity);
        for (Element node : list) {
            String detailedContent = JDomUtils.getChildText((Element)node, (String)"detailedContent");
            if (StringUtils.isEmpty((String)detailedContent)) continue;
            String[] contents = StringUtils.split((String)detailedContent, (String)SPLITSTR);
            String sequnce = contents[14];
            String status = contents[22];
            String msg = contents[23];
            BankResponseResult result = new BankResponseResult(status, SUCCESSCODES, FAILEDCODES);
            result.setBankMessage(msg);
            resultMap.put(sequnce, result);
        }
        return resultMap;
    }

    public static String packPayContent(PaymentInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append(Strings.padStart((String)info.getBankSerialNo(), (int)8, (char)'0')).append(SPLITSTR).append(info.is2SameBank() ? "0" : "1").append(SPLITSTR).append(info.is2Individual() ? "1" : "0").append(SPLITSTR).append("1").append(SPLITSTR).append(info.getIncomeAccNo()).append(SPLITSTR).append(info.getIncomeAccName()).append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR).append(info.getAmount().toString()).append(SPLITSTR).append("").append(SPLITSTR).append(info.getBankDetailSeqId()).append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR).append(info.getExplanation()).append(SPLITSTR).append(info.getExplanation()).append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR).append("").append(SPLITSTR);
        return sb.toString();
    }
}

