/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ClearCode {
    private static Map<String, String> shangHaiSameCityNames2Id = new HashMap<String, String>(16);
    private static String[] names = null;
    private static ClearCode instance = null;
    private static final String CONFIG_FILE = "shanghaisamecity.xml";

    private ClearCode() {
    }

    public static synchronized ClearCode instance() {
        if (null == instance) {
            instance = new ClearCode();
        }
        return instance;
    }

    public String getBackConpAndName(PaymentInfo paymentInfo) {
        this.initShangHaiSameCity();
        String bankName = paymentInfo.getIncomeBankName();
        for (int i = 0; i < names.length; ++i) {
            if (-1 == bankName.indexOf(names[i])) continue;
            String bccd = shangHaiSameCityNames2Id.get(names[i]);
            return bccd + "@_" + names[i];
        }
        return "";
    }

    private void initShangHaiSameCity() {
        try (InputStream is = this.getShangHaiSameCityConfigAsIS();){
            String content = IOUtils.readFully((InputStream)is, (String)"UTF-8");
            Element root = JDomUtils.string2Root((String)content, (String)"UTF-8");
            List list = root.getChildren("bank");
            names = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String name;
                Element bank = (Element)list.get(i);
                String id = bank.getChildText("id");
                ClearCode.names[i] = name = bank.getChildText("name");
                shangHaiSameCityNames2Id.put(name, id);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6c11\u751f\u94f6\u884c\u4ea4\u6362\u6570\u636e(\u63a5\u6536\u6e05\u7b97\u884c\u884c\u53f7)\u5f02\u5e38\u3002", (String)"ClearCode_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private InputStream getShangHaiSameCityConfigAsIS() {
        InputStream inputStream = null;
        try {
            inputStream = ClearCode.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6shanghaisamecity.xml\u6587\u4ef6\u3002", (String)"ClearCode_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return inputStream;
    }
}

