/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceNewImpl
extends AbstractBalanceImpl
implements IBalance {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BalanceNewImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        if (!request.getStartDate().isEqual(request.getEndDate())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u53ea\u652f\u6301\u5355\u65e5\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
        }
        EBBankBalanceResponse response = this.process(request);
        return response;
    }

    /*
     * Exception decompiling
     */
    public EBBankBalanceResponse process(BankBalanceRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "query.balance";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest rqst) {
        Element root = Packer.createMessageWithHead("qryBalNew");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element acntListElements = JDomUtils.addChild((Element)xdataBody, (String)"acntList");
        String reqAccNo = rqst.getAcnt().getAccNo();
        JDomUtils.addChild((Element)acntListElements, (String)"acntNo", (String)reqAccNo);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
        Element xDataBody = root.getChild("xDataBody");
        Element balList = xDataBody.getChild("balList");
        List list = balList.getChildren();
        if (list.size() == 0) {
            return new EBBankBalanceResponse();
        }
        ArrayList<BalanceInfo> arraylist = new ArrayList<BalanceInfo>(1);
        String currency = rqst.getBankCurrency();
        for (Object o : list) {
            Element balInfo = (Element)o;
            BalanceInfo balanceinfo = this.parseCurBalanceNew(balInfo, currency);
            if (balanceinfo == null) continue;
            arraylist.add(balanceinfo);
        }
        return new EBBankBalanceResponse(arraylist);
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return false;
    }

    private BalanceInfo parseCurBalanceNew(Element balInfo, String bankCurrency) throws EBServiceException {
        String state = balInfo.getChildTextTrim("state");
        if (!"1".equalsIgnoreCase(state)) {
            String errCode = balInfo.getChildTextTrim("errCode");
            String errMsg = balInfo.getChildTextTrim("errMsg");
            log.info("\u67e5\u8be2\u4f59\u989d\u5931\u8d25:" + errCode + "," + errMsg);
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25:%1$s\uff0c%2$s\u3002", (String)"TodayBalanceParser_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), errCode, errMsg));
        }
        log.info("\u67e5\u8be2\u4f59\u989d\u6210\u529f.");
        String acntNo = JDomUtils.getChildText((Element)balInfo, (String)"acntNo");
        String acntName = JDomUtils.getChildText((Element)balInfo, (String)"acntName");
        String acctBal = JDomUtils.getChildText((Element)balInfo, (String)"acctBal");
        String avlBal = JDomUtils.getChildText((Element)balInfo, (String)"avlBal");
        String frzBal = JDomUtils.getChildText((Element)balInfo, (String)"frzBal");
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u8d26\u53f7:" + acntNo);
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u6237\u540d:" + acntName);
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u5f53\u524d\u4f59\u989d:" + acctBal);
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u53ef\u7528\u4f59\u989d:" + avlBal);
        BankAcnt bankacnt = new BankAcnt();
        bankacnt.setAccNo(acntNo);
        bankacnt.setAccName(acntName);
        BalanceInfo balanceinfo = new BalanceInfo();
        BalanceUtil.setFreezeBalance((BalanceInfo)balanceinfo, (String)frzBal);
        BalanceUtil.setBankAcnt((BalanceInfo)balanceinfo, (BankAcnt)bankacnt);
        BalanceUtil.setBalanceDateTime((BalanceInfo)balanceinfo, (LocalDateTime)LocalDateTime.now());
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceinfo, (String)acctBal);
        BalanceUtil.setBankCurrency((BalanceInfo)balanceinfo, (String)bankCurrency);
        BalanceUtil.setAvailableBalance((BalanceInfo)balanceinfo, (String)avlBal);
        return balanceinfo;
    }

    public boolean match(BankBalanceRequest rqst) {
        return !BankBusinessConfig.isVirtualAccount(rqst.getAcnt().getAccNo()) && !AcntHelp.isCashPoolAcnt(rqst.getAcnt().getAccNo()) && !BankBusinessConfig.isMarginAccount(rqst.getAcnt().getAccNo()) && !BankBusinessConfig.isFixedAcnt(rqst.getAcnt().getAccNo());
    }
}

