/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance.fixed;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FixedBalanceParser
implements Constants {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(FixedBalanceParser.class);

    public static EBBankBalanceResponse parseTodayBalance(BankBalanceRequest request, String rspStr) throws EBServiceException {
        log.info("\u6c11\u751f\u94f6\u884c-\u8d26\u53f7\uff1a{}-\u5b9a\u671f\u6237\u4f59\u989d\u67e5\u8be2-queryRegularList\u63a5\u53e3-\u54cd\u5e94\u53c2\u6570\uff1a{}", new Object[]{request.getAcnt().getAccNo(), rspStr});
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)request.getAcnt(), (String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"FixedBalanceParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
        Element xDataBody = root.getChild("xDataBody");
        String totalNum = xDataBody.getChildTextTrim("totalNum");
        int total = Integer.parseInt(totalNum);
        Element acctList = xDataBody.getChild("balList");
        List acctInfos = acctList.getChildren("balInfo");
        HashMap balanceMap = new HashMap(16);
        for (Element element : acctInfos) {
            String accNo = JDomUtils.getChildText((Element)element, (String)"account");
            HashMap<String, String> balanceInfoMap = new HashMap<String, String>(16);
            String acctBal = JDomUtils.getChildText((Element)element, (String)"acctBal");
            String acctName = JDomUtils.getChildText((Element)element, (String)"acctName");
            String currNo = JDomUtils.getChildText((Element)element, (String)"currCode");
            balanceInfoMap.put("acctName", acctName);
            balanceInfoMap.put("acctBal", acctBal);
            balanceInfoMap.put("currNo", currNo);
            balanceMap.put(accNo + currNo, balanceInfoMap);
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        String rqstccNo = request.getAcnt().getAccNo();
        String currency = request.getCurrency();
        Map value = (Map)balanceMap.get(rqstccNo + currency);
        if (value == null || StringUtils.isEmpty((String)((String)value.get("acctBal")))) {
            int current = Integer.parseInt(RequestContextUtils.getRunningParam((String)"pageKey"));
            int nextTag = current + 20;
            if (total <= current) {
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(request.getAcnt());
                balanceInfo.setBalanceDateTime(LocalDateTime.now());
                balanceInfo.setError(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8be5\u8d26\u53f7\u4f59\u989d\u3002", (String)"FixedBalanceParser_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
                ArrayList balances = new ArrayList(16);
                return new EBBankBalanceResponse(balances);
            }
            RequestContextUtils.setRunningParam((String)"lastPageKey", (String)String.valueOf(false));
            RequestContextUtils.setRunningParam((String)"pageKey", (String)String.valueOf(nextTag));
            ArrayList balances = new ArrayList(16);
            return new EBBankBalanceResponse(balances);
        }
        log.info("\u5b58\u5728\u8be5\u8d26\u53f7\u8be5\u5e01\u79cd\u7684\u4fe1\u606f\uff0c\u51c6\u5907\u89e3\u6790");
        String balance = (String)value.get("acctBal");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (LocalDateTime)LocalDateTime.now());
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)balance);
        BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)((String)value.get("currNo")));
        balanceInfos.add(balanceInfo);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        bankBalanceResponse.setBalances(balanceInfos);
        return bankBalanceResponse;
    }
}

