/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balancereconciliation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    public String pack(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        Element root = Packer.createMessageWithHead("VerifyAccRecConf");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"confDate", (String)detail.getMonth());
        String customNo = BankBusinessConfig.getCustomNo(detail.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"customNo", (String)customNo);
        StringBuilder confContent = new StringBuilder();
        confContent.append("0").append("|").append(detail.getStatementNo()).append("|").append(detail.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"confContent", (String)confContent.toString());
        JDomUtils.addChild((Element)xdataBody, (String)"extendReq1", (String)"");
        JDomUtils.addChild((Element)xdataBody, (String)"extendReq2", (String)"");
        JDomUtils.addChild((Element)xdataBody, (String)"extendReq3", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String rspStr) {
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUBMITED, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "VerifyAccRecConf";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u56de\u6267\u786e\u8ba4", (String)"BalanceReconciliationImpl_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        return true;
    }
}

