/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balancereconciliation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    public int getMonthSpan() {
        return 1;
    }

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        String accNo = bankBalanceStatementRequest.getAccNo();
        String startMonth = bankBalanceStatementRequest.getStartMonth();
        Element root = Packer.createMessageWithHead("QryVerifyAccRecList");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"qryYear", (String)startMonth.substring(0, 4));
        JDomUtils.addChild((Element)xdataBody, (String)"qryMonth", (String)startMonth.substring(4, 6));
        JDomUtils.addChild((Element)xdataBody, (String)"startNo", (String)"1");
        JDomUtils.addChild((Element)xdataBody, (String)"queryRows", (String)"100");
        String customNo = BankBusinessConfig.getCustomNo(accNo);
        JDomUtils.addChild((Element)xdataBody, (String)"customNo", (String)customNo);
        JDomUtils.addChild((Element)xdataBody, (String)"extendReq1", (String)"");
        JDomUtils.addChild((Element)xdataBody, (String)"extendReq2", (String)"");
        JDomUtils.addChild((Element)xdataBody, (String)"extendReq3", (String)"");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            Element xDataBody = root.getChild("xDataBody");
            Element list = xDataBody.getChild("List");
            if (list == null) {
                return new EBBankBalanceStatementResponse((List)Lists.newArrayList());
            }
            List lists = list.getChildren("Map");
            ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(lists.size());
            for (Element element : lists) {
                String checkSeq = element.getChildText("CheckSeq");
                String currency = element.getChildText("Currency");
                String acNo = element.getChildText("AcNo");
                String balance = element.getChildText("Balance");
                String status = element.getChildText("status");
                if (!"0".equalsIgnoreCase(status) && !"3".equalsIgnoreCase(status)) continue;
                BalanceReconciliationDetail balanceReconciliationDetail = new BalanceReconciliationDetail();
                balanceReconciliationDetail.setAccNo(acNo);
                balanceReconciliationDetail.setCurrency(currency);
                balanceReconciliationDetail.setStatementNo(checkSeq);
                balanceReconciliationDetail.setBalance(balance);
                balanceReconciliationDetail.setMonth(bankBalanceStatementRequest.getStartMonth());
                detailList.add(balanceReconciliationDetail);
            }
            return new EBBankBalanceStatementResponse(detailList);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5f85\u586b\u5199\u7684\u5bf9\u8d26\u56de\u6267\u5217\u8868\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38,\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"BalanceStatementImpl_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "QryVerifyAccRecList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u53ef\u586b\u5199\u5bf9\u8d26\u5355\u56de\u6267\u5217\u8868", (String)"BalanceStatementImpl_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return true;
    }
}

