/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.detail;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.DateHelper;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NewDetailPacker {
    public static int QUERYROWS = 500;

    public static String packTodayDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        if (BankBusinessConfig.isVirtualAccount(rqst.getAcnt().getAccNo())) {
            return NewDetailPacker.packVitualDetailMsg(rqst, pageTag);
        }
        return NewDetailPacker.commonPacker(rqst, pageTag);
    }

    public static String packHisDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        if (BankBusinessConfig.isVirtualAccount(rqst.getAcnt().getAccNo())) {
            return NewDetailPacker.packVitualDetailMsg(rqst, pageTag);
        }
        return NewDetailPacker.commonPacker(rqst, pageTag);
    }

    private static String commonPacker(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        Element root = Packer.createMessageWithHead("detailLoad");
        Element reqBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)reqBody, (String)"trnId", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)reqBody, (String)"acntNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)reqBody, (String)"dateFrom", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)reqBody, (String)"dateTo", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        int pageNum = Integer.parseInt(pageTag);
        if (pageNum != 1) {
            pageNum = (pageNum - 1) * QUERYROWS + 1;
        }
        JDomUtils.addChild((Element)reqBody, (String)"startNo", (String)("" + pageNum));
        JDomUtils.addChild((Element)reqBody, (String)"queryRows", (String)("" + QUERYROWS));
        JDomUtils.addChild((Element)reqBody, (String)"typeCode", (String)"2");
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String trsDtlDownLoadPacker(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        Element root = Packer.createMessageWithHead("trsDtlDownLoad");
        Element reqBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)reqBody, (String)"trnId", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)reqBody, (String)"acntNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)reqBody, (String)"dateFrom", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)reqBody, (String)"dateTo", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        int pageNum = Integer.parseInt(pageTag);
        if (pageNum != 1) {
            pageNum = (pageNum - 1) * QUERYROWS + 1;
        }
        JDomUtils.addChild((Element)reqBody, (String)"startNo", (String)("" + pageNum));
        JDomUtils.addChild((Element)reqBody, (String)"queryRows", (String)("" + QUERYROWS));
        JDomUtils.addChild((Element)reqBody, (String)"typeCode", (String)"2");
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packVitualDetailMsg(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        Element root = Packer.createMessageWithHead("B2EVirtualTransDetailQryNew");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.gen16Sequence());
        String accNoString = rqst.getAcnt().getAccNo();
        String entityNo = accNoString.substring(0, accNoString.length() - 7);
        String virtualNo = accNoString.substring(accNoString.length() - 6, accNoString.length());
        JDomUtils.addChild((Element)xdataBody, (String)"AcNo", (String)entityNo);
        JDomUtils.addChild((Element)xdataBody, (String)"VirtualAcNo", (String)virtualNo);
        JDomUtils.addChild((Element)xdataBody, (String)"dateFrom", (String)DateHelper.formatDate(rqst.getStartDate()));
        JDomUtils.addChild((Element)xdataBody, (String)"dateTo", (String)DateHelper.formatDate(rqst.getEndDate()));
        int pageNum = Integer.parseInt(pageTag);
        if (pageNum != 1) {
            pageNum = (pageNum - 1) * QUERYROWS + 1;
        }
        JDomUtils.addChild((Element)xdataBody, (String)"currentIndex", (String)("" + pageNum));
        JDomUtils.addChild((Element)xdataBody, (String)"pageSize", (String)("" + QUERYROWS));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }
}

