/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "batchCostReimb";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1\u4ee3\u62a5\u9500", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equalsIgnoreCase(subBizType)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
                return paymentInfo.is2SameBank() && !BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo());
            }
            if (UseConvertor.isReim((PaymentInfo)paymentInfo)) {
                return paymentInfo.is2SameBank() && !BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo()) && paymentInfo.is2Merge();
            }
        }
        if ("pay".equalsIgnoreCase(subBizType) && UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            return paymentInfo.is2SameBank() && !BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo());
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        return PayPacker.packPay(request.getPaymentInfoAsArray(), "batchCostReimb");
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
    }
}

