/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salarynew;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salarynew.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salarynew.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "batchCostReimbNew";
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65b0\u6279\u91cf\u8d39\u7528\u62a5\u9500\u3001\u4ee3\u53d1\u5de5\u8d44", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equals(subBizType) || "pay".equals(subBizType)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            if (UseConvertor.isSalary((PaymentInfo)paymentInfo) || UseConvertor.isReim((PaymentInfo)paymentInfo)) {
                return !BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo()) && BankBusinessConfig.isSalary2NewInterface();
            }
        }
        return false;
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        return PayPacker.packPay(request.getPaymentInfos());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
    }
}

